/*
 * Decompiled with CFR 0.152.
 */
package dlshade.com.scurrilous.circe;

import dlshade.com.scurrilous.circe.HashParameters;
import dlshade.com.scurrilous.circe.HashProvider;
import dlshade.com.scurrilous.circe.HashSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ServiceLoader;
import java.util.SortedMap;
import java.util.TreeMap;

public final class HashProviders {
    static final Collection<HashProvider> ALL_PROVIDERS = HashProviders.getAllProviders();

    private static Collection<HashProvider> getAllProviders() {
        ServiceLoader<HashProvider> loader = ServiceLoader.load(HashProvider.class);
        LinkedList<HashProvider> providers = new LinkedList<HashProvider>();
        for (HashProvider provider : loader) {
            providers.add(provider);
        }
        return Collections.unmodifiableList(new ArrayList(providers));
    }

    private HashProviders() {
    }

    public static Iterator<HashProvider> iterator() {
        return ALL_PROVIDERS.iterator();
    }

    public static HashProvider best(HashParameters params) {
        return HashProviders.best(params, EnumSet.of(HashSupport.STATEFUL));
    }

    public static HashProvider best(HashParameters params, EnumSet<HashSupport> required) {
        HashProvider result = null;
        EnumSet<HashSupport> resultSupport = null;
        for (HashProvider provider : ALL_PROVIDERS) {
            EnumSet<HashSupport> support = provider.querySupport(params);
            if (!support.containsAll(required) || result != null && HashSupport.compare(support, resultSupport) >= 0) continue;
            result = provider;
            resultSupport = support;
        }
        if (result == null) {
            throw new UnsupportedOperationException();
        }
        return result;
    }

    public static SortedMap<EnumSet<HashSupport>, HashProvider> search(HashParameters params) {
        return HashProviders.search(params, EnumSet.of(HashSupport.STATEFUL));
    }

    public static SortedMap<EnumSet<HashSupport>, HashProvider> search(HashParameters params, EnumSet<HashSupport> required) {
        TreeMap<EnumSet<HashSupport>, HashProvider> result = new TreeMap<EnumSet<HashSupport>, HashProvider>(new HashSupport.SetComparator());
        for (HashProvider provider : ALL_PROVIDERS) {
            EnumSet<HashSupport> support = provider.querySupport(params);
            if (!support.containsAll(required)) continue;
            result.put(support, provider);
        }
        return result;
    }
}

