/*
 * Decompiled with CFR 0.152.
 */
package dlshade.com.scurrilous.circe;

import dlshade.com.scurrilous.circe.HashParameters;
import dlshade.com.scurrilous.circe.HashProviders;
import dlshade.com.scurrilous.circe.HashSupport;
import dlshade.com.scurrilous.circe.IncrementalIntHash;
import dlshade.com.scurrilous.circe.IncrementalLongHash;
import dlshade.com.scurrilous.circe.StatefulHash;
import dlshade.com.scurrilous.circe.StatelessIntHash;
import dlshade.com.scurrilous.circe.StatelessLongHash;
import java.util.EnumSet;

public final class Hashes {
    private Hashes() {
    }

    public static StatefulHash createStateful(HashParameters params) {
        return HashProviders.best(params).createStateful(params);
    }

    public static StatelessIntHash getStatelessInt(HashParameters params) {
        return HashProviders.best(params, EnumSet.of(HashSupport.INT_SIZED)).getStatelessInt(params);
    }

    public static StatelessLongHash getStatelessLong(HashParameters params) {
        return HashProviders.best(params, EnumSet.of(HashSupport.LONG_SIZED)).getStatelessLong(params);
    }

    public static IncrementalIntHash getIncrementalInt(HashParameters params) {
        return HashProviders.best(params, EnumSet.of(HashSupport.INT_SIZED, HashSupport.STATELESS_INCREMENTAL)).getIncrementalInt(params);
    }

    public static IncrementalLongHash getIncrementalLong(HashParameters params) {
        return HashProviders.best(params, EnumSet.of(HashSupport.LONG_SIZED, HashSupport.STATELESS_INCREMENTAL)).getIncrementalLong(params);
    }
}

