/*
 * Decompiled with CFR 0.152.
 */
package dlshade.com.scurrilous.circe.impl;

import dlshade.com.scurrilous.circe.StatelessLongHash;
import java.nio.ByteBuffer;

public abstract class AbstractStatelessLongHash
implements StatelessLongHash {
    @Override
    public boolean supportsUnsafe() {
        return false;
    }

    @Override
    public long calculate(byte[] input) {
        return this.calculateUnchecked(input, 0, input.length);
    }

    @Override
    public long calculate(byte[] input, int index, int length) {
        if (length < 0) {
            throw new IllegalArgumentException();
        }
        if (index < 0 || index + length > input.length) {
            throw new IndexOutOfBoundsException();
        }
        return this.calculateUnchecked(input, index, length);
    }

    @Override
    public long calculate(ByteBuffer input) {
        int index;
        byte[] array;
        int length = input.remaining();
        if (input.hasArray()) {
            array = input.array();
            index = input.arrayOffset() + input.position();
            input.position(input.limit());
        } else {
            array = new byte[length];
            index = 0;
            input.get(array);
        }
        return this.calculateUnchecked(array, index, length);
    }

    @Override
    public long calculate(long address, long length) {
        throw new UnsupportedOperationException();
    }

    protected abstract long calculateUnchecked(byte[] var1, int var2, int var3);
}

