/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.bookkeeper.bookie;

import dlshade.org.apache.bookkeeper.bookie.BookieFileChannel;
import dlshade.org.apache.bookkeeper.conf.ServerConfiguration;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;

public interface FileChannelProvider
extends Closeable {
    public static FileChannelProvider newProvider(String providerClassName) throws IOException {
        try {
            Class<?> providerClass = Class.forName(providerClassName);
            Object obj = providerClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            return (FileChannelProvider)obj;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public BookieFileChannel open(File var1, ServerConfiguration var2) throws IOException;

    public void close(BookieFileChannel var1) throws IOException;

    default public boolean supportReuseFile() {
        return false;
    }

    default public void notifyRename(File source, File target) {
    }
}

