/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.bookkeeper.bookie;

import dlshade.org.apache.bookkeeper.bookie.BookieException;
import dlshade.org.apache.bookkeeper.bookie.BookieImpl;
import dlshade.org.apache.bookkeeper.bookie.LedgerDirsManager;
import dlshade.org.apache.bookkeeper.bookie.LedgerStorage;
import dlshade.org.apache.bookkeeper.conf.ServerConfiguration;
import dlshade.org.apache.bookkeeper.discover.BookieServiceInfo;
import dlshade.org.apache.bookkeeper.discover.RegistrationManager;
import dlshade.org.apache.bookkeeper.stats.StatsLogger;
import dlshade.org.apache.bookkeeper.util.DiskChecker;
import dlshade.org.apache.zookeeper.KeeperException;
import io.netty.buffer.ByteBufAllocator;
import java.io.IOException;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadOnlyBookie
extends BookieImpl {
    private static final Logger LOG = LoggerFactory.getLogger(ReadOnlyBookie.class);

    public ReadOnlyBookie(ServerConfiguration conf, RegistrationManager registrationManager, LedgerStorage storage, DiskChecker diskChecker, LedgerDirsManager ledgerDirsManager, LedgerDirsManager indexDirsManager, StatsLogger statsLogger, ByteBufAllocator allocator, Supplier<BookieServiceInfo> bookieServiceInfoProvider) throws IOException, KeeperException, InterruptedException, BookieException {
        super(conf, registrationManager, storage, diskChecker, ledgerDirsManager, indexDirsManager, statsLogger, allocator, bookieServiceInfoProvider);
        if (!conf.isReadOnlyModeEnabled()) {
            String err = "Try to init ReadOnly Bookie, while ReadOnly mode is not enabled";
            LOG.error(err);
            throw new IOException(err);
        }
        this.stateManager.forceToReadOnly();
        LOG.info("Running bookie in force readonly mode.");
    }
}

