/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.bookkeeper.bookie.datainteg;

import dlshade.org.apache.bookkeeper.bookie.BookieException;
import dlshade.org.apache.bookkeeper.bookie.BookieImpl;
import dlshade.org.apache.bookkeeper.bookie.Cookie;
import dlshade.org.apache.bookkeeper.bookie.CookieValidation;
import dlshade.org.apache.bookkeeper.bookie.datainteg.DataIntegrityCheck;
import dlshade.org.apache.bookkeeper.conf.ServerConfiguration;
import dlshade.org.apache.bookkeeper.discover.RegistrationManager;
import dlshade.org.apache.bookkeeper.net.BookieId;
import dlshade.org.apache.bookkeeper.versioning.Version;
import dlshade.org.apache.bookkeeper.versioning.Versioned;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataIntegrityCookieValidation
implements CookieValidation {
    private static final Logger log = LoggerFactory.getLogger(DataIntegrityCookieValidation.class);
    private final ServerConfiguration conf;
    private final BookieId bookieId;
    private final RegistrationManager registrationManager;
    private final DataIntegrityCheck dataIntegCheck;

    public DataIntegrityCookieValidation(ServerConfiguration conf, RegistrationManager registrationManager, DataIntegrityCheck dataIntegCheck) throws UnknownHostException {
        this.conf = conf;
        this.registrationManager = registrationManager;
        this.bookieId = BookieImpl.getBookieId(conf);
        this.dataIntegCheck = dataIntegCheck;
    }

    private Optional<Versioned<Cookie>> getRegManagerCookie() throws BookieException {
        try {
            return Optional.of(Cookie.readFromRegistrationManager(this.registrationManager, this.bookieId));
        }
        catch (BookieException.CookieNotFoundException noCookieException) {
            return Optional.empty();
        }
    }

    private List<Optional<Cookie>> collectDirectoryCookies(List<File> directories) throws BookieException {
        ArrayList<Optional<Cookie>> cookies = new ArrayList<Optional<Cookie>>();
        for (File d : directories) {
            try {
                cookies.add(Optional.of(Cookie.readFromDirectory(d)));
            }
            catch (FileNotFoundException fnfe) {
                cookies.add(Optional.empty());
            }
            catch (IOException ioe) {
                throw new BookieException.InvalidCookieException(ioe);
            }
        }
        return cookies;
    }

    private void stampCookie(Cookie masterCookie, Version expectedVersion, List<File> directories) throws BookieException {
        log.info("Stamping cookie to ZK");
        masterCookie.writeToRegistrationManager(this.registrationManager, this.conf, expectedVersion);
        for (File d : directories) {
            try {
                log.info("Stamping cookie to directory {}", (Object)d);
                masterCookie.writeToDirectory(d);
            }
            catch (IOException ioe) {
                log.error("Exception writing cookie", (Throwable)ioe);
                throw new BookieException.InvalidCookieException(ioe);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void checkCookies(List<File> directories) throws BookieException, InterruptedException {
        Cookie masterCookie;
        String instanceId = this.registrationManager.getClusterInstanceId();
        if (instanceId == null) {
            throw new BookieException.InvalidCookieException("Cluster instance ID unavailable");
        }
        try {
            masterCookie = Cookie.generateCookie(this.conf).setInstanceId(instanceId).build();
        }
        catch (UnknownHostException uhe) {
            throw new BookieException.InvalidCookieException(uhe);
        }
        Optional<Versioned<Cookie>> regManagerCookie = this.getRegManagerCookie();
        List<Optional<Cookie>> directoryCookies = this.collectDirectoryCookies(directories);
        if (!regManagerCookie.isPresent()) {
            if (directoryCookies.stream().noneMatch(Optional::isPresent)) {
                log.info("New environment found. Stamping cookies");
                this.stampCookie(masterCookie, Version.NEW, directories);
                return;
            }
            String errorMsg = "Cookie missing from ZK. Either it was manually deleted, or the bookie was started pointing to a different ZK cluster than the one it was originally started with. This requires manual intervention to fix";
            log.error(errorMsg);
            throw new BookieException.InvalidCookieException(errorMsg);
        }
        if (regManagerCookie.get().getValue().equals(masterCookie) && directoryCookies.stream().allMatch(c -> c.map(masterCookie::equals).orElse(false))) return;
        if (this.conf.isDataIntegrityStampMissingCookiesEnabled()) {
            log.warn("ZK cookie({}) or directory cookies({}) do not match master cookie ({}), running check", new Object[]{regManagerCookie, directoryCookies, masterCookie});
            try {
                this.dataIntegCheck.runPreBootCheck("INVALID_COOKIE").get();
            }
            catch (ExecutionException ee) {
                if (!(ee.getCause() instanceof BookieException)) throw new BookieException.InvalidCookieException(ee.getCause());
                throw (BookieException)ee.getCause();
            }
            log.info("Environment should be in a sane state. Stamp new cookies");
            this.stampCookie(masterCookie, regManagerCookie.get().getVersion(), directories);
            return;
        }
        String errorMsg = MessageFormat.format("ZK cookie({0}) or directory cookies({1}) do not match master cookie ({2}) and missing cookie stamping is disabled.", regManagerCookie, directoryCookies, masterCookie);
        log.error(errorMsg);
        throw new BookieException.InvalidCookieException(errorMsg);
    }
}

