/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.bookkeeper.bookie.storage.directentrylogger;

import dlshade.org.apache.bookkeeper.common.util.ExceptionMessageHelper;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;

class Header {
    static final int LOGFILE_LEGACY_HEADER_SIZE = 1024;
    static final int LOGFILE_DIRECT_HEADER_SIZE = 4096;
    static final int HEADER_VERSION_OFFSET = 4;
    static final int LEDGERS_MAP_OFFSET = 8;
    static final int LEDGER_COUNT_OFFSET = 16;
    static final int HEADER_V0 = 0;
    static final int HEADER_V1 = 1;
    static final int HEADER_CURRENT_VERSION = 1;
    static final byte[] EMPTY_HEADER = new byte[4096];

    Header() {
    }

    static int extractVersion(ByteBuf header) throws IOException {
        Header.assertFingerPrint(header);
        return header.getInt(4);
    }

    static long extractLedgerMapOffset(ByteBuf header) throws IOException {
        Header.assertFingerPrint(header);
        return header.getLong(8);
    }

    static int extractLedgerCount(ByteBuf header) throws IOException {
        Header.assertFingerPrint(header);
        return header.getInt(16);
    }

    static void assertFingerPrint(ByteBuf header) throws IOException {
        if (header.getByte(0) != 66 || header.getByte(1) != 75 || header.getByte(2) != 76 || header.getByte(3) != 79) {
            throw new IOException(ExceptionMessageHelper.exMsg("Bad fingerprint (should be BKLO)").kv("byte0", header.getByte(0)).kv("byte1", header.getByte(1)).kv("byte2", header.getByte(2)).kv("byte3", header.getByte(3)).toString());
        }
    }

    static void writeEmptyHeader(ByteBuf header) throws IOException {
        header.writeBytes(EMPTY_HEADER);
    }

    static void writeHeader(ByteBuf header, long ledgerMapOffset, int ledgerCount) throws IOException {
        header.writeBytes(EMPTY_HEADER);
        header.setLong(8, ledgerMapOffset);
        header.setInt(16, ledgerCount);
    }

    static {
        ByteBuf buf = Unpooled.wrappedBuffer((byte[])EMPTY_HEADER);
        buf.setByte(0, 66);
        buf.setByte(1, 75);
        buf.setByte(2, 76);
        buf.setByte(3, 79);
        buf.setInt(4, 1);
        buf.setInt(1024, buf.capacity() - 1024 - 4);
        buf.setLong(1028, -1L);
    }
}

