/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.bookkeeper.bookie.storage.directentrylogger;

import dlshade.org.apache.bookkeeper.bookie.storage.EntryLogScanner;
import dlshade.org.apache.bookkeeper.bookie.storage.directentrylogger.Buffer;
import dlshade.org.apache.bookkeeper.bookie.storage.directentrylogger.LogReader;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.ReferenceCountUtil;
import java.io.IOException;

class LogReaderScan {
    LogReaderScan() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void scan(ByteBufAllocator allocator, LogReader reader, EntryLogScanner scanner) throws IOException {
        int offset = 1024;
        ByteBuf entry = allocator.directBuffer(0x1000000);
        try {
            while ((long)offset < reader.maxOffset()) {
                int initOffset = offset;
                int entrySize = reader.readIntAt(offset);
                if (entrySize < 0) {
                    offset = Buffer.nextAlignment(offset);
                    continue;
                }
                if (entrySize == 0) {
                    break;
                }
                entry.clear();
                reader.readIntoBufferAt(entry, offset += 4, entrySize);
                long ledgerId = entry.getLong(0);
                if (ledgerId >= 0L && scanner.accept(ledgerId)) {
                    scanner.process(ledgerId, initOffset, entry);
                }
                offset += entrySize;
            }
        }
        finally {
            ReferenceCountUtil.release((Object)entry);
        }
    }
}

