/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.bookkeeper.bookie.storage.ldb;

import dlshade.com.google.common.base.Preconditions;
import dlshade.org.apache.bookkeeper.bookie.storage.ldb.DbLedgerStorage;
import dlshade.org.apache.bookkeeper.bookie.storage.ldb.KeyValueStorage;
import dlshade.org.apache.bookkeeper.bookie.storage.ldb.KeyValueStorageFactory;
import dlshade.org.apache.bookkeeper.conf.ServerConfiguration;
import dlshade.org.rocksdb.BlockBasedTableConfig;
import dlshade.org.rocksdb.BloomFilter;
import dlshade.org.rocksdb.Cache;
import dlshade.org.rocksdb.ChecksumType;
import dlshade.org.rocksdb.ColumnFamilyDescriptor;
import dlshade.org.rocksdb.ColumnFamilyHandle;
import dlshade.org.rocksdb.CompressionType;
import dlshade.org.rocksdb.DBOptions;
import dlshade.org.rocksdb.Env;
import dlshade.org.rocksdb.InfoLogLevel;
import dlshade.org.rocksdb.LRUCache;
import dlshade.org.rocksdb.LiveFileMetaData;
import dlshade.org.rocksdb.Options;
import dlshade.org.rocksdb.OptionsUtil;
import dlshade.org.rocksdb.ReadOptions;
import dlshade.org.rocksdb.RocksDB;
import dlshade.org.rocksdb.RocksDBException;
import dlshade.org.rocksdb.RocksIterator;
import dlshade.org.rocksdb.RocksObject;
import dlshade.org.rocksdb.Slice;
import dlshade.org.rocksdb.WriteBatch;
import dlshade.org.rocksdb.WriteOptions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.netty.util.internal.PlatformDependent;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyValueStorageRocksDB
implements KeyValueStorage {
    static KeyValueStorageFactory factory = (defaultBasePath, subPath, dbConfigType, conf) -> new KeyValueStorageRocksDB(defaultBasePath, subPath, dbConfigType, conf);
    private final RocksDB db;
    private RocksObject options;
    private List<ColumnFamilyDescriptor> columnFamilyDescriptors;
    private final WriteOptions optionSync;
    private final WriteOptions optionDontSync;
    private Cache cache;
    private final ReadOptions optionCache;
    private final ReadOptions optionDontCache;
    private final WriteBatch emptyBatch;
    private final int writeBatchMaxSize;
    private String dbPath;
    private static final String ROCKSDB_LOG_PATH = "dbStorage_rocksDB_logPath";
    private static final String ROCKSDB_LOG_LEVEL = "dbStorage_rocksDB_logLevel";
    private static final String ROCKSDB_LZ4_COMPRESSION_ENABLED = "dbStorage_rocksDB_lz4CompressionEnabled";
    private static final String ROCKSDB_WRITE_BUFFER_SIZE_MB = "dbStorage_rocksDB_writeBufferSizeMB";
    private static final String ROCKSDB_SST_SIZE_MB = "dbStorage_rocksDB_sstSizeInMB";
    private static final String ROCKSDB_BLOCK_SIZE = "dbStorage_rocksDB_blockSize";
    private static final String ROCKSDB_BLOOM_FILTERS_BITS_PER_KEY = "dbStorage_rocksDB_bloomFilterBitsPerKey";
    private static final String ROCKSDB_BLOCK_CACHE_SIZE = "dbStorage_rocksDB_blockCacheSize";
    private static final String ROCKSDB_NUM_LEVELS = "dbStorage_rocksDB_numLevels";
    private static final String ROCKSDB_NUM_FILES_IN_LEVEL0 = "dbStorage_rocksDB_numFilesInLevel0";
    private static final String ROCKSDB_MAX_SIZE_IN_LEVEL1_MB = "dbStorage_rocksDB_maxSizeInLevel1MB";
    private static final String ROCKSDB_FORMAT_VERSION = "dbStorage_rocksDB_format_version";
    private static final String ROCKSDB_CHECKSUM_TYPE = "dbStorage_rocksDB_checksum_type";
    private static final Logger log = LoggerFactory.getLogger(KeyValueStorageRocksDB.class);

    public KeyValueStorageRocksDB(String basePath, String subPath, KeyValueStorageFactory.DbConfigType dbConfigType, ServerConfiguration conf) throws IOException {
        this(basePath, subPath, dbConfigType, conf, false);
    }

    public KeyValueStorageRocksDB(String basePath, String subPath, KeyValueStorageFactory.DbConfigType dbConfigType, ServerConfiguration conf, boolean readOnly) throws IOException {
        try {
            RocksDB.loadLibrary();
        }
        catch (Throwable t) {
            throw new IOException("Failed to load RocksDB JNI library", t);
        }
        this.optionSync = new WriteOptions();
        this.optionDontSync = new WriteOptions();
        this.optionCache = new ReadOptions();
        this.optionDontCache = new ReadOptions();
        this.emptyBatch = new WriteBatch();
        String dbFilePath = "";
        dbFilePath = dbConfigType == KeyValueStorageFactory.DbConfigType.EntryLocation ? conf.getEntryLocationRocksdbConf() : (dbConfigType == KeyValueStorageFactory.DbConfigType.LedgerMetadata ? conf.getLedgerMetadataRocksdbConf() : conf.getDefaultRocksDBConf());
        log.info("Searching for a RocksDB configuration file in {}", (Object)dbFilePath);
        if (Paths.get(dbFilePath, new String[0]).toFile().exists()) {
            log.info("Found a RocksDB configuration file and using it to initialize the RocksDB");
            this.db = this.initializeRocksDBWithConfFile(basePath, subPath, dbConfigType, conf, readOnly, dbFilePath);
        } else {
            log.info("Haven't found the file and read the configuration from the main bookkeeper configuration");
            this.db = this.initializeRocksDBWithBookieConf(basePath, subPath, dbConfigType, conf, readOnly);
        }
        this.optionSync.setSync(true);
        this.optionDontSync.setSync(false);
        this.optionCache.setFillCache(true);
        this.optionDontCache.setFillCache(false);
        this.writeBatchMaxSize = conf.getMaxOperationNumbersInSingleRocksDBBatch();
    }

    private RocksDB initializeRocksDBWithConfFile(String basePath, String subPath, KeyValueStorageFactory.DbConfigType dbConfigType, ServerConfiguration conf, boolean readOnly, String dbFilePath) throws IOException {
        DBOptions dbOptions = new DBOptions();
        ArrayList<ColumnFamilyDescriptor> cfDescs = new ArrayList<ColumnFamilyDescriptor>();
        ArrayList<ColumnFamilyHandle> cfHandles = new ArrayList<ColumnFamilyHandle>();
        try {
            OptionsUtil.loadOptionsFromFile(dbFilePath, Env.getDefault(), dbOptions, cfDescs, false);
            String logPath = conf.getString(ROCKSDB_LOG_PATH, "");
            if (!logPath.isEmpty()) {
                Path logPathSetting = FileSystems.getDefault().getPath(logPath, subPath);
                Files.createDirectories(logPathSetting, new FileAttribute[0]);
                log.info("RocksDB<{}> log path: {}", (Object)subPath, (Object)logPathSetting);
                dbOptions.setDbLogDir(logPathSetting.toString());
            }
            this.dbPath = FileSystems.getDefault().getPath(basePath, subPath).toFile().toString();
            this.options = dbOptions;
            this.columnFamilyDescriptors = cfDescs;
            if (readOnly) {
                return RocksDB.openReadOnly(dbOptions, this.dbPath, cfDescs, cfHandles);
            }
            return RocksDB.open(dbOptions, this.dbPath, cfDescs, cfHandles);
        }
        catch (RocksDBException e) {
            throw new IOException("Error open RocksDB database", e);
        }
    }

    private RocksDB initializeRocksDBWithBookieConf(String basePath, String subPath, KeyValueStorageFactory.DbConfigType dbConfigType, ServerConfiguration conf, boolean readOnly) throws IOException {
        String logLevel;
        Options options = new Options();
        options.setCreateIfMissing(true);
        ChecksumType checksumType = ChecksumType.valueOf(conf.getString(ROCKSDB_CHECKSUM_TYPE, "kxxHash"));
        if (dbConfigType == KeyValueStorageFactory.DbConfigType.EntryLocation) {
            int ledgerDirsSize = conf.getLedgerDirNames().length;
            long defaultRocksDBBlockCacheSizeBytes = PlatformDependent.maxDirectMemory() / (long)ledgerDirsSize / 10L;
            long blockCacheSize = DbLedgerStorage.getLongVariableOrDefault(conf, ROCKSDB_BLOCK_CACHE_SIZE, defaultRocksDBBlockCacheSizeBytes);
            long writeBufferSizeMB = conf.getInt(ROCKSDB_WRITE_BUFFER_SIZE_MB, 64);
            long sstSizeMB = conf.getInt(ROCKSDB_SST_SIZE_MB, 64);
            int numLevels = conf.getInt(ROCKSDB_NUM_LEVELS, -1);
            int numFilesInLevel0 = conf.getInt(ROCKSDB_NUM_FILES_IN_LEVEL0, 4);
            long maxSizeInLevel1MB = conf.getLong(ROCKSDB_MAX_SIZE_IN_LEVEL1_MB, 256L);
            int blockSize = conf.getInt(ROCKSDB_BLOCK_SIZE, 65536);
            int bloomFilterBitsPerKey = conf.getInt(ROCKSDB_BLOOM_FILTERS_BITS_PER_KEY, 10);
            boolean lz4CompressionEnabled = conf.getBoolean(ROCKSDB_LZ4_COMPRESSION_ENABLED, true);
            int formatVersion = conf.getInt(ROCKSDB_FORMAT_VERSION, 2);
            if (lz4CompressionEnabled) {
                options.setCompressionType(CompressionType.LZ4_COMPRESSION);
            }
            options.setWriteBufferSize(writeBufferSizeMB * 1024L * 1024L);
            options.setMaxWriteBufferNumber(4);
            if (numLevels > 0) {
                options.setNumLevels(numLevels);
            }
            options.setLevelZeroFileNumCompactionTrigger(numFilesInLevel0);
            options.setMaxBytesForLevelBase(maxSizeInLevel1MB * 1024L * 1024L);
            options.setMaxBackgroundJobs(32);
            options.setIncreaseParallelism(32);
            options.setMaxTotalWalSize(0x20000000L);
            options.setMaxOpenFiles(-1);
            options.setTargetFileSizeBase(sstSizeMB * 1024L * 1024L);
            options.setDeleteObsoleteFilesPeriodMicros(TimeUnit.HOURS.toMicros(1L));
            this.cache = new LRUCache(blockCacheSize);
            BlockBasedTableConfig tableOptions = new BlockBasedTableConfig();
            tableOptions.setBlockSize(blockSize);
            tableOptions.setBlockCache(this.cache);
            tableOptions.setFormatVersion(formatVersion);
            tableOptions.setChecksumType(checksumType);
            if (bloomFilterBitsPerKey > 0) {
                tableOptions.setFilterPolicy(new BloomFilter(bloomFilterBitsPerKey, false));
            }
            tableOptions.setCacheIndexAndFilterBlocks(true);
            options.setLevelCompactionDynamicLevelBytes(true);
            options.setTableFormatConfig(tableOptions);
        } else {
            this.cache = null;
            BlockBasedTableConfig tableOptions = new BlockBasedTableConfig();
            tableOptions.setChecksumType(checksumType);
            options.setTableFormatConfig(tableOptions);
        }
        String logPath = conf.getString(ROCKSDB_LOG_PATH, "");
        if (!logPath.isEmpty()) {
            Path logPathSetting = FileSystems.getDefault().getPath(logPath, subPath);
            Files.createDirectories(logPathSetting, new FileAttribute[0]);
            log.info("RocksDB<{}> log path: {}", (Object)subPath, (Object)logPathSetting);
            options.setDbLogDir(logPathSetting.toString());
        }
        this.dbPath = FileSystems.getDefault().getPath(basePath, subPath).toFile().toString();
        switch (logLevel = conf.getString(ROCKSDB_LOG_LEVEL, "info")) {
            case "debug": {
                options.setInfoLogLevel(InfoLogLevel.DEBUG_LEVEL);
                break;
            }
            case "info": {
                options.setInfoLogLevel(InfoLogLevel.INFO_LEVEL);
                break;
            }
            case "warn": {
                options.setInfoLogLevel(InfoLogLevel.WARN_LEVEL);
                break;
            }
            case "error": {
                options.setInfoLogLevel(InfoLogLevel.ERROR_LEVEL);
                break;
            }
            default: {
                log.warn("Unrecognized RockDB log level: {}", (Object)logLevel);
            }
        }
        options.setKeepLogFileNum(30L);
        options.setLogFileTimeToRoll(TimeUnit.DAYS.toSeconds(1L));
        this.options = options;
        try {
            if (readOnly) {
                return RocksDB.openReadOnly(options, this.dbPath);
            }
            return RocksDB.open(options, this.dbPath);
        }
        catch (RocksDBException e) {
            throw new IOException("Error open RocksDB database", e);
        }
    }

    @Override
    public void close() throws IOException {
        this.db.close();
        if (this.cache != null) {
            this.cache.close();
        }
        if (this.options != null) {
            this.options.close();
        }
        this.optionSync.close();
        this.optionDontSync.close();
        this.optionCache.close();
        this.optionDontCache.close();
        this.emptyBatch.close();
    }

    @Override
    public void put(byte[] key, byte[] value) throws IOException {
        try {
            this.db.put(this.optionDontSync, key, value);
        }
        catch (RocksDBException e) {
            throw new IOException("Error in RocksDB put", e);
        }
    }

    @Override
    public byte[] get(byte[] key) throws IOException {
        try {
            return this.db.get(key);
        }
        catch (RocksDBException e) {
            throw new IOException("Error in RocksDB get", e);
        }
    }

    @Override
    public int get(byte[] key, byte[] value) throws IOException {
        try {
            int res = this.db.get(key, value);
            if (res == -1) {
                return -1;
            }
            if (res > value.length) {
                throw new IOException("Value array is too small to fit the result");
            }
            return res;
        }
        catch (RocksDBException e) {
            throw new IOException("Error in RocksDB get", e);
        }
    }

    @Override
    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"})
    public Map.Entry<byte[], byte[]> getFloor(byte[] key) throws IOException {
        try (Slice upperBound = new Slice(key);
             ReadOptions option = new ReadOptions(this.optionCache).setIterateUpperBound(upperBound);
             RocksIterator iterator = this.db.newIterator(option);){
            iterator.seekToLast();
            if (iterator.isValid()) {
                EntryWrapper entryWrapper = new EntryWrapper(iterator.key(), iterator.value());
                return entryWrapper;
            }
        }
        return null;
    }

    @Override
    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"})
    public Map.Entry<byte[], byte[]> getCeil(byte[] key) throws IOException {
        try (RocksIterator iterator = this.db.newIterator(this.optionCache);){
            iterator.seek(key);
            if (iterator.isValid()) {
                EntryWrapper entryWrapper = new EntryWrapper(iterator.key(), iterator.value());
                return entryWrapper;
            }
            Map.Entry<byte[], byte[]> entry = null;
            return entry;
        }
    }

    @Override
    public void delete(byte[] key) throws IOException {
        try {
            this.db.delete(this.optionDontSync, key);
        }
        catch (RocksDBException e) {
            throw new IOException("Error in RocksDB delete", e);
        }
    }

    @Override
    public String getDBPath() {
        return this.dbPath;
    }

    @Override
    public void compact(byte[] firstKey, byte[] lastKey) throws IOException {
        try {
            this.db.compactRange(firstKey, lastKey);
        }
        catch (RocksDBException e) {
            throw new IOException("Error in RocksDB compact", e);
        }
    }

    @Override
    public void compact() throws IOException {
        try {
            long start = System.currentTimeMillis();
            int oriRocksDBFileCount = this.db.getLiveFilesMetaData().size();
            long oriRocksDBSize = this.getRocksDBSize();
            log.info("Starting RocksDB {} compact, current RocksDB hold {} files and {} Bytes.", new Object[]{this.db.getName(), oriRocksDBFileCount, oriRocksDBSize});
            this.db.compactRange();
            long end = System.currentTimeMillis();
            int rocksDBFileCount = this.db.getLiveFilesMetaData().size();
            long rocksDBSize = this.getRocksDBSize();
            log.info("RocksDB {} compact finished {} ms, space reduced {} Bytes, current hold {} files and {} Bytes.", new Object[]{this.db.getName(), end - start, oriRocksDBSize - rocksDBSize, rocksDBFileCount, rocksDBSize});
        }
        catch (RocksDBException e) {
            throw new IOException("Error in RocksDB compact", e);
        }
    }

    private long getRocksDBSize() {
        List<LiveFileMetaData> liveFilesMetaData = this.db.getLiveFilesMetaData();
        long rocksDBFileSize = 0L;
        for (LiveFileMetaData fileMetaData : liveFilesMetaData) {
            rocksDBFileSize += fileMetaData.size();
        }
        return rocksDBFileSize;
    }

    @Override
    public void sync() throws IOException {
        try {
            this.db.write(this.optionSync, this.emptyBatch);
        }
        catch (RocksDBException e) {
            throw new IOException(e);
        }
    }

    @Override
    public KeyValueStorage.CloseableIterator<byte[]> keys() {
        final RocksIterator iterator = this.db.newIterator(this.optionCache);
        iterator.seekToFirst();
        return new KeyValueStorage.CloseableIterator<byte[]>(){

            @Override
            public boolean hasNext() {
                return iterator.isValid();
            }

            @Override
            public byte[] next() {
                Preconditions.checkState(iterator.isValid());
                byte[] key = iterator.key();
                iterator.next();
                return key;
            }

            @Override
            public void close() {
                iterator.close();
            }
        };
    }

    @Override
    public KeyValueStorage.CloseableIterator<byte[]> keys(byte[] firstKey, byte[] lastKey) {
        final Slice upperBound = new Slice(lastKey);
        final ReadOptions option = new ReadOptions(this.optionCache).setIterateUpperBound(upperBound);
        final RocksIterator iterator = this.db.newIterator(option);
        iterator.seek(firstKey);
        return new KeyValueStorage.CloseableIterator<byte[]>(){

            @Override
            public boolean hasNext() {
                return iterator.isValid();
            }

            @Override
            public byte[] next() {
                Preconditions.checkState(iterator.isValid());
                byte[] key = iterator.key();
                iterator.next();
                return key;
            }

            @Override
            public void close() {
                iterator.close();
                option.close();
                upperBound.close();
            }
        };
    }

    @Override
    public KeyValueStorage.CloseableIterator<Map.Entry<byte[], byte[]>> iterator() {
        final RocksIterator iterator = this.db.newIterator(this.optionDontCache);
        iterator.seekToFirst();
        final EntryWrapper entryWrapper = new EntryWrapper();
        return new KeyValueStorage.CloseableIterator<Map.Entry<byte[], byte[]>>(){

            @Override
            public boolean hasNext() {
                return iterator.isValid();
            }

            @Override
            public Map.Entry<byte[], byte[]> next() {
                Preconditions.checkState(iterator.isValid());
                EntryWrapper.access$002(entryWrapper, iterator.key());
                EntryWrapper.access$102(entryWrapper, iterator.value());
                iterator.next();
                return entryWrapper;
            }

            @Override
            public void close() {
                iterator.close();
            }
        };
    }

    @Override
    public long count() throws IOException {
        try {
            return this.db.getLongProperty("rocksdb.estimate-num-keys");
        }
        catch (RocksDBException e) {
            throw new IOException("Error in getting records count", e);
        }
    }

    @Override
    public KeyValueStorage.Batch newBatch() {
        return new RocksDBBatch(this.writeBatchMaxSize);
    }

    RocksDB db() {
        return this.db;
    }

    List<ColumnFamilyDescriptor> getColumnFamilyDescriptors() {
        return this.columnFamilyDescriptors;
    }

    RocksObject getOptions() {
        return this.options;
    }

    private static final class EntryWrapper
    implements Map.Entry<byte[], byte[]> {
        private byte[] key;
        private byte[] value;

        public EntryWrapper() {
            this.key = null;
            this.value = null;
        }

        public EntryWrapper(byte[] key, byte[] value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public byte[] setValue(byte[] value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public byte[] getValue() {
            return this.value;
        }

        @Override
        public byte[] getKey() {
            return this.key;
        }

        static /* synthetic */ byte[] access$002(EntryWrapper x0, byte[] x1) {
            x0.key = x1;
            return x1;
        }

        static /* synthetic */ byte[] access$102(EntryWrapper x0, byte[] x1) {
            x0.value = x1;
            return x1;
        }
    }

    private class RocksDBBatch
    implements KeyValueStorage.Batch {
        private final WriteBatch writeBatch = new WriteBatch();
        private final int batchSize;
        private int batchCount = 0;

        RocksDBBatch(int batchSize) {
            this.batchSize = batchSize;
        }

        @Override
        public void close() {
            this.writeBatch.close();
            this.batchCount = 0;
        }

        @Override
        public void put(byte[] key, byte[] value) throws IOException {
            try {
                this.writeBatch.put(key, value);
                this.countBatchAndFlushIfNeeded();
            }
            catch (RocksDBException e) {
                throw new IOException("Failed to flush RocksDB batch", e);
            }
        }

        @Override
        public void remove(byte[] key) throws IOException {
            try {
                this.writeBatch.delete(key);
                this.countBatchAndFlushIfNeeded();
            }
            catch (RocksDBException e) {
                throw new IOException("Failed to flush RocksDB batch", e);
            }
        }

        @Override
        public void clear() {
            this.writeBatch.clear();
            this.batchCount = 0;
        }

        @Override
        public void deleteRange(byte[] beginKey, byte[] endKey) throws IOException {
            try {
                this.writeBatch.deleteRange(beginKey, endKey);
                this.countBatchAndFlushIfNeeded();
            }
            catch (RocksDBException e) {
                throw new IOException("Failed to flush RocksDB batch", e);
            }
        }

        private void countBatchAndFlushIfNeeded() throws IOException {
            if (++this.batchCount >= this.batchSize) {
                this.flush();
                this.clear();
            }
        }

        @Override
        public int batchCount() {
            return this.batchCount;
        }

        @Override
        public void flush() throws IOException {
            try {
                KeyValueStorageRocksDB.this.db.write(KeyValueStorageRocksDB.this.optionSync, this.writeBatch);
            }
            catch (RocksDBException e) {
                throw new IOException("Failed to flush RocksDB batch", e);
            }
        }
    }
}

