/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.bookkeeper.client;

import dlshade.com.google.common.base.Preconditions;
import dlshade.org.apache.bookkeeper.client.impl.LedgerEntryImpl;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import java.io.InputStream;

public class LedgerEntry {
    final long ledgerId;
    final long entryId;
    final long length;
    ByteBuf data;

    LedgerEntry(LedgerEntryImpl entry) {
        this.ledgerId = entry.getLedgerId();
        this.entryId = entry.getEntryId();
        this.length = entry.getLength();
        this.data = entry.getEntryBuffer().retain();
    }

    public long getLedgerId() {
        return this.ledgerId;
    }

    public long getEntryId() {
        return this.entryId;
    }

    public long getLength() {
        return this.length;
    }

    public byte[] getEntry() {
        Preconditions.checkState(null != this.data, "entry content can be accessed only once");
        byte[] entry = new byte[this.data.readableBytes()];
        this.data.readBytes(entry);
        this.data.release();
        this.data = null;
        return entry;
    }

    public InputStream getEntryInputStream() {
        Preconditions.checkState(null != this.data, "entry content can be accessed only once");
        ByteBufInputStream res = new ByteBufInputStream(this.data);
        this.data = null;
        return res;
    }

    public ByteBuf getEntryBuffer() {
        Preconditions.checkState(null != this.data, "entry content has been retrieved by #getEntry or #getEntryInputStream");
        return this.data;
    }
}

