/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.bookkeeper.client;

import dlshade.com.google.common.base.Preconditions;
import dlshade.org.apache.bookkeeper.client.LedgerMetadataImpl;
import dlshade.org.apache.bookkeeper.client.api.LedgerMetadata;
import dlshade.org.apache.bookkeeper.net.BookieId;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LedgerMetadataUtils {
    static final Logger LOG = LoggerFactory.getLogger(LedgerMetadataUtils.class);

    static List<BookieId> getCurrentEnsemble(LedgerMetadata metadata) {
        return LedgerMetadataUtils.getLastEnsembleValue(metadata);
    }

    static long getNextEnsembleChange(LedgerMetadata metadata, long entryId) {
        SortedMap<Long, ? extends List<BookieId>> tailMap = metadata.getAllEnsembles().tailMap(entryId + 1L);
        if (tailMap.isEmpty()) {
            return -1L;
        }
        return tailMap.firstKey();
    }

    static Set<BookieId> getBookiesInThisLedger(LedgerMetadata metadata) {
        HashSet<BookieId> bookies = new HashSet<BookieId>();
        for (List ensemble : metadata.getAllEnsembles().values()) {
            bookies.addAll(ensemble);
        }
        return bookies;
    }

    static List<BookieId> getLastEnsembleValue(LedgerMetadata metadata) {
        Preconditions.checkArgument(!metadata.getAllEnsembles().isEmpty(), "Metadata should never be created with no ensembles");
        return metadata.getAllEnsembles().lastEntry().getValue();
    }

    static Long getLastEnsembleKey(LedgerMetadata metadata) {
        Preconditions.checkArgument(!metadata.getAllEnsembles().isEmpty(), "Metadata should never be created with no ensembles");
        return (Long)metadata.getAllEnsembles().lastKey();
    }

    public static boolean shouldStoreCtime(LedgerMetadata metadata) {
        return metadata instanceof LedgerMetadataImpl && ((LedgerMetadataImpl)metadata).shouldStoreCtime();
    }
}

