/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.bookkeeper.client;

import dlshade.org.apache.bookkeeper.client.BKException;
import dlshade.org.apache.bookkeeper.client.BookKeeper;
import dlshade.org.apache.bookkeeper.client.ClientContext;
import dlshade.org.apache.bookkeeper.client.DistributionSchedule;
import dlshade.org.apache.bookkeeper.client.LedgerHandle;
import dlshade.org.apache.bookkeeper.client.PendingReadOp;
import dlshade.org.apache.bookkeeper.client.ReadLastConfirmedOp;
import dlshade.org.apache.bookkeeper.client.api.LedgerEntries;
import dlshade.org.apache.bookkeeper.client.api.LedgerEntry;
import dlshade.org.apache.bookkeeper.client.impl.LedgerEntryImpl;
import dlshade.org.apache.bookkeeper.common.concurrent.FutureEventListener;
import dlshade.org.apache.bookkeeper.net.BookieId;
import dlshade.org.apache.bookkeeper.net.BookieSocketAddress;
import dlshade.org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import dlshade.org.apache.bookkeeper.proto.checksum.DigestManager;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.ReferenceCountUtil;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;

public class LedgerReader {
    private final ClientContext clientCtx;

    public LedgerReader(BookKeeper bkc) {
        this.clientCtx = bkc.getClientCtx();
    }

    public static SortedMap<Long, ? extends List<BookieId>> bookiesForLedger(LedgerHandle lh) {
        return lh.getLedgerMetadata().getAllEnsembles();
    }

    public void readEntriesFromAllBookies(final LedgerHandle lh, long eid, final BookkeeperInternalCallbacks.GenericCallback<Set<ReadResult<ByteBuf>>> callback) {
        DistributionSchedule.WriteSet writeSet = lh.distributionSchedule.getWriteSet(eid);
        final AtomicInteger numBookies = new AtomicInteger(writeSet.size());
        final HashSet readResults = new HashSet();
        BookkeeperInternalCallbacks.ReadEntryCallback readEntryCallback = new BookkeeperInternalCallbacks.ReadEntryCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void readEntryComplete(int rc, long lid, long eid, ByteBuf buffer, Object ctx) {
                ReadResult<Object> rr;
                BookieSocketAddress bookieAddress = (BookieSocketAddress)ctx;
                if (0 != rc) {
                    rr = new ReadResult<Object>(eid, rc, null, bookieAddress.getSocketAddress());
                } else {
                    try {
                        ByteBuf content = lh.macManager.verifyDigestAndReturnData(eid, buffer);
                        ByteBuf toRet = Unpooled.copiedBuffer((ByteBuf)content);
                        rr = new ReadResult<ByteBuf>(eid, 0, toRet, bookieAddress.getSocketAddress());
                    }
                    catch (BKException.BKDigestMatchException e) {
                        rr = new ReadResult<Object>(eid, -5, null, bookieAddress.getSocketAddress());
                    }
                    finally {
                        ReferenceCountUtil.release((Object)buffer);
                    }
                }
                readResults.add(rr);
                if (numBookies.decrementAndGet() == 0) {
                    callback.operationComplete(0, readResults);
                }
            }
        };
        List<BookieId> ensemble = lh.getLedgerMetadata().getEnsembleAt(eid);
        for (int i = 0; i < writeSet.size(); ++i) {
            int idx = writeSet.get(i);
            BookieSocketAddress resolvedNetworkAddress = this.clientCtx.getBookieWatcher().getBookieAddressResolver().resolve(ensemble.get(idx));
            this.clientCtx.getBookieClient().readEntry(ensemble.get(idx), lh.getId(), eid, readEntryCallback, resolvedNetworkAddress, 0);
        }
    }

    public void forwardReadEntriesFromLastConfirmed(final LedgerHandle lh, final BookkeeperInternalCallbacks.GenericCallback<List<dlshade.org.apache.bookkeeper.client.LedgerEntry>> callback) {
        final ArrayList resultList = new ArrayList();
        FutureEventListener<LedgerEntries> readListener = new FutureEventListener<LedgerEntries>(){

            private void readNext(long entryId) {
                PendingReadOp op = new PendingReadOp(lh, LedgerReader.this.clientCtx, entryId, entryId, false);
                op.future().whenComplete((BiConsumer)this);
                op.submit();
            }

            @Override
            public void onSuccess(LedgerEntries ledgerEntries) {
                long entryId = -1L;
                for (LedgerEntry entry : ledgerEntries) {
                    resultList.add(new dlshade.org.apache.bookkeeper.client.LedgerEntry((LedgerEntryImpl)entry));
                    entryId = entry.getEntryId();
                }
                try {
                    ledgerEntries.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.readNext(++entryId);
            }

            @Override
            public void onFailure(Throwable throwable) {
                if (throwable instanceof BKException.BKNoSuchEntryException) {
                    callback.operationComplete(0, resultList);
                } else {
                    int retCode = throwable instanceof BKException ? ((BKException)throwable).getCode() : -999;
                    callback.operationComplete(retCode, resultList);
                }
            }
        };
        ReadLastConfirmedOp.LastConfirmedDataCallback readLACCallback = (rc, recoveryData) -> {
            if (0 != rc) {
                callback.operationComplete(rc, resultList);
                return;
            }
            if (-1L >= recoveryData.getLastAddConfirmed()) {
                callback.operationComplete(0, resultList);
                return;
            }
            long entryId = recoveryData.getLastAddConfirmed();
            PendingReadOp op = new PendingReadOp(lh, this.clientCtx, entryId, entryId, false);
            op.future().whenComplete(readListener);
            op.submit();
        };
        new ReadLastConfirmedOp(this.clientCtx.getBookieClient(), lh.distributionSchedule, lh.macManager, lh.ledgerId, lh.getCurrentEnsemble(), lh.ledgerKey, readLACCallback).initiate();
    }

    public void readLacs(LedgerHandle lh, long eid, BookkeeperInternalCallbacks.GenericCallback<Set<ReadResult<Long>>> callback) {
        DistributionSchedule.WriteSet writeSet = lh.distributionSchedule.getWriteSet(eid);
        AtomicInteger numBookies = new AtomicInteger(writeSet.size());
        HashSet readResults = new HashSet();
        BookkeeperInternalCallbacks.ReadEntryCallback readEntryCallback = (rc, lid, eid1, buffer, ctx) -> {
            ReadResult<Object> rr;
            InetSocketAddress bookieAddress = (InetSocketAddress)ctx;
            if (0 != rc) {
                rr = new ReadResult<Object>(eid1, rc, null, bookieAddress);
            } else {
                try {
                    DigestManager.RecoveryData data = lh.macManager.verifyDigestAndReturnLastConfirmed(buffer);
                    rr = new ReadResult<Long>(eid1, 0, data.getLastAddConfirmed(), bookieAddress);
                }
                catch (BKException.BKDigestMatchException e) {
                    rr = new ReadResult<Object>(eid1, -5, null, bookieAddress);
                }
            }
            readResults.add(rr);
            if (numBookies.decrementAndGet() == 0) {
                callback.operationComplete(0, readResults);
            }
        };
        List<BookieId> ensemble = lh.getLedgerMetadata().getEnsembleAt(eid);
        for (int i = 0; i < writeSet.size(); ++i) {
            int idx = writeSet.get(i);
            this.clientCtx.getBookieClient().readEntry(ensemble.get(idx), lh.getId(), eid, readEntryCallback, ensemble.get(idx), 0);
        }
    }

    public static class ReadResult<T> {
        final long entryId;
        final int rc;
        final T value;
        final InetSocketAddress srcAddr;

        ReadResult(long entryId, int rc, T value, InetSocketAddress srcAddr) {
            this.entryId = entryId;
            this.rc = rc;
            this.value = value;
            this.srcAddr = srcAddr;
        }

        public long getEntryId() {
            return this.entryId;
        }

        public int getResultCode() {
            return this.rc;
        }

        public T getValue() {
            return this.value;
        }

        public InetSocketAddress getBookieAddress() {
            return this.srcAddr;
        }
    }
}

