/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.bookkeeper.client;

import dlshade.com.google.common.annotations.VisibleForTesting;
import dlshade.com.google.common.base.MoreObjects;
import dlshade.com.google.common.collect.ImmutableMap;
import dlshade.org.apache.bookkeeper.client.DistributionSchedule;
import dlshade.org.apache.bookkeeper.net.BookieId;
import io.netty.util.Recycler;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoundRobinDistributionSchedule
implements DistributionSchedule {
    private static final Logger LOG = LoggerFactory.getLogger(RoundRobinDistributionSchedule.class);
    private final int writeQuorumSize;
    private final int ackQuorumSize;
    private final int ensembleSize;

    public RoundRobinDistributionSchedule(int writeQuorumSize, int ackQuorumSize, int ensembleSize) {
        this.writeQuorumSize = writeQuorumSize;
        this.ackQuorumSize = ackQuorumSize;
        this.ensembleSize = ensembleSize;
    }

    @Override
    public DistributionSchedule.WriteSet getWriteSet(long entryId) {
        return WriteSetImpl.create(this.ensembleSize, this.writeQuorumSize, entryId);
    }

    @Override
    public int getWriteSetBookieIndex(long entryId, int writeSetIndex) {
        return (int)(entryId + (long)writeSetIndex) % this.ensembleSize;
    }

    @Override
    public DistributionSchedule.WriteSet getEnsembleSet(long entryId) {
        return WriteSetImpl.create(this.ensembleSize, this.ensembleSize, entryId);
    }

    @VisibleForTesting
    static DistributionSchedule.WriteSet writeSetFromValues(Integer ... values) {
        WriteSetImpl writeSet = WriteSetImpl.create(0, 0, 0L);
        writeSet.setSize(values.length);
        for (int i = 0; i < values.length; ++i) {
            writeSet.set(i, values[i]);
        }
        return writeSet;
    }

    @Override
    public DistributionSchedule.AckSet getAckSet() {
        return AckSetImpl.create(this.ensembleSize, this.writeQuorumSize, this.ackQuorumSize);
    }

    @Override
    public DistributionSchedule.AckSet getEnsembleAckSet() {
        return AckSetImpl.create(this.ensembleSize, this.ensembleSize, this.ensembleSize);
    }

    @Override
    public DistributionSchedule.QuorumCoverageSet getCoverageSet() {
        return new RRQuorumCoverageSet();
    }

    @Override
    public boolean hasEntry(long entryId, int bookieIndex) {
        for (int w = 0; w < this.writeQuorumSize; ++w) {
            if (bookieIndex != this.getWriteSetBookieIndex(entryId, w)) continue;
            return true;
        }
        return false;
    }

    @Override
    public BitSet getEntriesStripedToTheBookie(int bookieIndex, long startEntryId, long lastEntryId) {
        if (startEntryId < 0L || lastEntryId < 0L || bookieIndex < 0 || bookieIndex >= this.ensembleSize || lastEntryId < startEntryId) {
            LOG.error("Illegal arguments for getEntriesStripedToTheBookie, bookieIndex : {}, ensembleSize : {}, startEntryId : {}, lastEntryId : {}", new Object[]{bookieIndex, this.ensembleSize, startEntryId, lastEntryId});
            throw new IllegalArgumentException("Illegal arguments for getEntriesStripedToTheBookie");
        }
        BitSet entriesStripedToTheBookie = new BitSet((int)(lastEntryId - startEntryId + 1L));
        for (long entryId = startEntryId; entryId <= lastEntryId; ++entryId) {
            int modValOfLastReplica = (int)((entryId + (long)this.writeQuorumSize - 1L) % (long)this.ensembleSize);
            int modValOfFirstReplica = (int)(entryId % (long)this.ensembleSize);
            if (modValOfLastReplica >= modValOfFirstReplica) {
                if (bookieIndex < modValOfFirstReplica || bookieIndex > modValOfLastReplica) continue;
                entriesStripedToTheBookie.set((int)(entryId - startEntryId));
                continue;
            }
            if (bookieIndex < modValOfFirstReplica && bookieIndex > modValOfLastReplica) continue;
            entriesStripedToTheBookie.set((int)(entryId - startEntryId));
        }
        return entriesStripedToTheBookie;
    }

    @Override
    public int getWriteQuorumSize() {
        return this.writeQuorumSize;
    }

    private class RRQuorumCoverageSet
    implements DistributionSchedule.QuorumCoverageSet {
        private final int[] covered;

        private RRQuorumCoverageSet() {
            this.covered = new int[RoundRobinDistributionSchedule.this.ensembleSize];
            for (int i = 0; i < this.covered.length; ++i) {
                this.covered[i] = 1;
            }
        }

        @Override
        public synchronized void addBookie(int bookieIndexHeardFrom, int rc) {
            this.covered[bookieIndexHeardFrom] = rc;
        }

        @Override
        public synchronized boolean checkCovered() {
            for (int i = 0; i < RoundRobinDistributionSchedule.this.ensembleSize; ++i) {
                int nodesUnknown = 0;
                for (int j = 0; j < RoundRobinDistributionSchedule.this.writeQuorumSize; ++j) {
                    int nodeIndex = (i + j) % RoundRobinDistributionSchedule.this.ensembleSize;
                    if (this.covered[nodeIndex] == 0 || this.covered[nodeIndex] == -13 || this.covered[nodeIndex] == -7) continue;
                    ++nodesUnknown;
                }
                if (nodesUnknown < RoundRobinDistributionSchedule.this.ackQuorumSize) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            int i;
            StringBuilder buffer = new StringBuilder();
            buffer.append("QuorumCoverage(e:").append(RoundRobinDistributionSchedule.this.ensembleSize).append(",w:").append(RoundRobinDistributionSchedule.this.writeQuorumSize).append(",a:").append(RoundRobinDistributionSchedule.this.ackQuorumSize).append(") = [");
            for (i = 0; i < this.covered.length - 1; ++i) {
                buffer.append(this.covered[i]).append(", ");
            }
            buffer.append(this.covered[i]).append("]");
            return buffer.toString();
        }
    }

    private static class AckSetImpl
    implements DistributionSchedule.AckSet {
        private int writeQuorumSize;
        private int ackQuorumSize;
        private final BitSet ackSet = new BitSet();
        private BookieId[] failureMap = new BookieId[0];
        private final Recycler.Handle<AckSetImpl> recyclerHandle;
        private static final Recycler<AckSetImpl> RECYCLER = new Recycler<AckSetImpl>(){

            protected AckSetImpl newObject(Recycler.Handle<AckSetImpl> handle) {
                return new AckSetImpl(handle);
            }
        };

        private AckSetImpl(Recycler.Handle<AckSetImpl> recyclerHandle) {
            this.recyclerHandle = recyclerHandle;
        }

        static AckSetImpl create(int ensembleSize, int writeQuorumSize, int ackQuorumSize) {
            AckSetImpl ackSet = (AckSetImpl)RECYCLER.get();
            ackSet.reset(ensembleSize, writeQuorumSize, ackQuorumSize);
            return ackSet;
        }

        private void reset(int ensembleSize, int writeQuorumSize, int ackQuorumSize) {
            this.ackQuorumSize = ackQuorumSize;
            this.writeQuorumSize = writeQuorumSize;
            this.ackSet.clear();
            if (this.failureMap.length < ensembleSize) {
                this.failureMap = new BookieId[ensembleSize];
            }
            Arrays.fill(this.failureMap, null);
        }

        @Override
        public boolean completeBookieAndCheck(int bookieIndexHeardFrom) {
            this.failureMap[bookieIndexHeardFrom] = null;
            this.ackSet.set(bookieIndexHeardFrom);
            return this.ackSet.cardinality() >= this.ackQuorumSize;
        }

        @Override
        public boolean failBookieAndCheck(int bookieIndexHeardFrom, BookieId address) {
            this.ackSet.clear(bookieIndexHeardFrom);
            this.failureMap[bookieIndexHeardFrom] = address;
            return this.failed() > this.writeQuorumSize - this.ackQuorumSize;
        }

        @Override
        public Map<Integer, BookieId> getFailedBookies() {
            ImmutableMap.Builder<Integer, BookieId> builder = new ImmutableMap.Builder<Integer, BookieId>();
            for (int i = 0; i < this.failureMap.length; ++i) {
                if (this.failureMap[i] == null) continue;
                builder.put(i, this.failureMap[i]);
            }
            return builder.build();
        }

        @Override
        public boolean removeBookieAndCheck(int bookie) {
            this.ackSet.clear(bookie);
            this.failureMap[bookie] = null;
            return this.ackSet.cardinality() >= this.ackQuorumSize;
        }

        @Override
        public void recycle() {
            this.recyclerHandle.recycle((Object)this);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("ackQuorumSize", this.ackQuorumSize).add("ackSet", this.ackSet).add("failureMap", this.failureMap).toString();
        }

        private int failed() {
            int count = 0;
            for (int i = 0; i < this.failureMap.length; ++i) {
                if (this.failureMap[i] == null) continue;
                ++count;
            }
            return count;
        }
    }

    private static class WriteSetImpl
    implements DistributionSchedule.WriteSet {
        int[] array = null;
        int size;
        private final Recycler.Handle<WriteSetImpl> recyclerHandle;
        private static final Recycler<WriteSetImpl> RECYCLER = new Recycler<WriteSetImpl>(){

            protected WriteSetImpl newObject(Recycler.Handle<WriteSetImpl> handle) {
                return new WriteSetImpl(handle);
            }
        };

        private WriteSetImpl(Recycler.Handle<WriteSetImpl> recyclerHandle) {
            this.recyclerHandle = recyclerHandle;
        }

        static WriteSetImpl create(int ensembleSize, int writeQuorumSize, long entryId) {
            WriteSetImpl writeSet = (WriteSetImpl)RECYCLER.get();
            writeSet.reset(ensembleSize, writeQuorumSize, entryId);
            return writeSet;
        }

        private void reset(int ensembleSize, int writeQuorumSize, long entryId) {
            this.setSize(writeQuorumSize);
            for (int w = 0; w < writeQuorumSize; ++w) {
                this.set(w, (int)((entryId + (long)w) % (long)ensembleSize));
            }
        }

        private void setSize(int newSize) {
            if (this.array == null) {
                this.array = new int[newSize];
            } else if (newSize > this.array.length) {
                int[] newArray = new int[newSize];
                System.arraycopy(this.array, 0, newArray, 0, this.array.length);
                this.array = newArray;
            }
            this.size = newSize;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public boolean contains(int i) {
            return this.indexOf(i) != -1;
        }

        @Override
        public int get(int i) {
            this.checkBounds(i);
            return this.array[i];
        }

        @Override
        public int set(int i, int index) {
            this.checkBounds(i);
            int oldVal = this.array[i];
            this.array[i] = index;
            return oldVal;
        }

        @Override
        public void sort() {
            Arrays.sort(this.array, 0, this.size);
        }

        @Override
        public int indexOf(int index) {
            for (int j = 0; j < this.size; ++j) {
                if (this.array[j] != index) continue;
                return j;
            }
            return -1;
        }

        @Override
        public void addMissingIndices(int maxIndex) {
            if (this.size < maxIndex) {
                int oldSize = this.size;
                this.setSize(maxIndex);
                int j = oldSize;
                for (int i = 0; i < maxIndex && j < maxIndex; ++i) {
                    if (this.contains(i)) continue;
                    this.set(j, i);
                    ++j;
                }
            }
        }

        @Override
        public void moveAndShift(int from, int to) {
            this.checkBounds(from);
            this.checkBounds(to);
            if (from > to) {
                int tmp = this.array[from];
                for (int i = from; i > to; --i) {
                    this.array[i] = this.array[i - 1];
                }
                this.array[to] = tmp;
            } else if (from < to) {
                int tmp = this.array[from];
                for (int i = from; i < to; ++i) {
                    this.array[i] = this.array[i + 1];
                }
                this.array[to] = tmp;
            }
        }

        @Override
        public void recycle() {
            this.recyclerHandle.recycle((Object)this);
        }

        @Override
        public DistributionSchedule.WriteSet copy() {
            WriteSetImpl copy = (WriteSetImpl)RECYCLER.get();
            copy.setSize(this.size);
            for (int i = 0; i < this.size; ++i) {
                copy.set(i, this.array[i]);
            }
            return copy;
        }

        public int hashCode() {
            int sum = 0;
            for (int i = 0; i < this.size; ++i) {
                sum += sum * 31 + i;
            }
            return sum;
        }

        public boolean equals(Object other) {
            if (other instanceof WriteSetImpl) {
                WriteSetImpl o = (WriteSetImpl)other;
                if (o.size() != this.size()) {
                    return false;
                }
                for (int i = 0; i < this.size(); ++i) {
                    if (o.get(i) == this.get(i)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public String toString() {
            int i;
            StringBuilder b = new StringBuilder("WriteSet[");
            for (i = 0; i < this.size() - 1; ++i) {
                b.append(this.get(i)).append(",");
            }
            b.append(this.get(i)).append("]");
            return b.toString();
        }

        private void checkBounds(int i) {
            if (i < 0 || i > this.size) {
                throw new IndexOutOfBoundsException("Index " + i + " out of bounds, array size = " + this.size);
            }
        }
    }
}

