/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.bookkeeper.client;

import dlshade.com.google.common.base.Preconditions;
import dlshade.com.google.common.cache.Cache;
import dlshade.com.google.common.cache.CacheBuilder;
import dlshade.com.google.common.cache.CacheLoader;
import dlshade.org.apache.bookkeeper.client.BKException;
import dlshade.org.apache.bookkeeper.client.BookiesHealthInfo;
import dlshade.org.apache.bookkeeper.client.DistributionSchedule;
import dlshade.org.apache.bookkeeper.client.DynamicWeightedRandomSelectionImpl;
import dlshade.org.apache.bookkeeper.client.EnsemblePlacementPolicy;
import dlshade.org.apache.bookkeeper.client.ITopologyAwareEnsemblePlacementPolicy;
import dlshade.org.apache.bookkeeper.client.TopologyAwareEnsemblePlacementPolicy;
import dlshade.org.apache.bookkeeper.common.util.ReflectionUtils;
import dlshade.org.apache.bookkeeper.conf.ClientConfiguration;
import dlshade.org.apache.bookkeeper.conf.Configurable;
import dlshade.org.apache.bookkeeper.feature.FeatureProvider;
import dlshade.org.apache.bookkeeper.net.BookieId;
import dlshade.org.apache.bookkeeper.net.BookieNode;
import dlshade.org.apache.bookkeeper.net.DNSToSwitchMapping;
import dlshade.org.apache.bookkeeper.net.NetworkTopologyImpl;
import dlshade.org.apache.bookkeeper.net.Node;
import dlshade.org.apache.bookkeeper.net.NodeBase;
import dlshade.org.apache.bookkeeper.net.ScriptBasedMapping;
import dlshade.org.apache.bookkeeper.net.StabilizeNetworkTopology;
import dlshade.org.apache.bookkeeper.proto.BookieAddressResolver;
import dlshade.org.apache.bookkeeper.stats.Counter;
import dlshade.org.apache.bookkeeper.stats.Gauge;
import dlshade.org.apache.bookkeeper.stats.StatsLogger;
import dlshade.org.apache.bookkeeper.stats.annotations.StatsDoc;
import dlshade.org.apache.commons.collections4.CollectionUtils;
import dlshade.org.apache.commons.lang3.StringUtils;
import io.netty.util.HashedWheelTimer;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZoneawareEnsemblePlacementPolicyImpl
extends TopologyAwareEnsemblePlacementPolicy {
    static final Logger LOG = LoggerFactory.getLogger(ZoneawareEnsemblePlacementPolicyImpl.class);
    public static final String UNKNOWN_ZONE = "UnknownZone";
    private String defaultFaultDomain = "/default-zone/default-upgradedomain";
    protected ZoneAwareNodeLocation unresolvedNodeLocation = new ZoneAwareNodeLocation("/default-zone", "/default-upgradedomain");
    private final Random rand;
    protected StatsLogger statsLogger = null;
    protected Cache<BookieId, Long> slowBookies;
    protected BookieNode myNode = null;
    protected String myZone = null;
    protected boolean reorderReadsRandom = false;
    protected int stabilizePeriodSeconds = 0;
    protected int reorderThresholdPendingRequests = 0;
    protected int maxWeightMultiple;
    protected int minNumZonesPerWriteQuorum;
    protected int desiredNumZonesPerWriteQuorum;
    protected boolean enforceStrictZoneawarePlacement;
    protected HashedWheelTimer timer;
    protected final ConcurrentMap<BookieId, ZoneAwareNodeLocation> address2NodePlacement = new ConcurrentHashMap<BookieId, ZoneAwareNodeLocation>();
    @StatsDoc(name="FAILED_TO_RESOLVE_NETWORK_LOCATION_TOTAL", help="Counter for number of times DNSResolverDecorator failed to resolve Network Location")
    protected Counter failedToResolveNetworkLocationCounter = null;
    @StatsDoc(name="NUM_WRITABLE_BOOKIES_IN_DEFAULT_FAULTDOMAIN", help="Gauge for the number of writable Bookies in default fault domain")
    protected Gauge<Integer> numWritableBookiesInDefaultFaultDomain;

    ZoneawareEnsemblePlacementPolicyImpl() {
        this.rand = new Random(System.currentTimeMillis());
    }

    protected ZoneAwareNodeLocation getZoneAwareNodeLocation(BookieId addr) {
        ZoneAwareNodeLocation nodeLocation = (ZoneAwareNodeLocation)this.address2NodePlacement.get(addr);
        if (null == nodeLocation) {
            String[] parts;
            String networkLocation = this.resolveNetworkLocation(addr);
            nodeLocation = this.getDefaultFaultDomain().equals(networkLocation) ? this.unresolvedNodeLocation : ((parts = StringUtils.split(NodeBase.normalize(networkLocation), '/')).length != 2 ? this.unresolvedNodeLocation : new ZoneAwareNodeLocation("/" + parts[0], "/" + parts[1]));
            this.address2NodePlacement.putIfAbsent(addr, nodeLocation);
        }
        return nodeLocation;
    }

    protected ZoneAwareNodeLocation getZoneAwareNodeLocation(BookieNode node) {
        if (null == node || null == node.getAddr()) {
            return this.unresolvedNodeLocation;
        }
        return this.getZoneAwareNodeLocation(node.getAddr());
    }

    @Override
    public EnsemblePlacementPolicy initialize(ClientConfiguration conf, Optional<DNSToSwitchMapping> optionalDnsResolver, HashedWheelTimer timer, FeatureProvider featureProvider, StatsLogger statsLogger, BookieAddressResolver bookieAddressResolver) {
        DNSToSwitchMapping actualDNSResolver;
        this.statsLogger = statsLogger;
        this.bookieAddressResolver = bookieAddressResolver;
        this.timer = timer;
        this.bookiesJoinedCounter = statsLogger.getOpStatsLogger("BOOKIES_JOINED");
        this.bookiesLeftCounter = statsLogger.getOpStatsLogger("BOOKIES_LEFT");
        this.failedToResolveNetworkLocationCounter = statsLogger.getCounter("FAILED_TO_RESOLVE_NETWORK_LOCATION_TOTAL");
        this.numWritableBookiesInDefaultFaultDomain = new Gauge<Integer>(){

            @Override
            public Integer getDefaultValue() {
                return 0;
            }

            @Override
            public Integer getSample() {
                ZoneawareEnsemblePlacementPolicyImpl.this.rwLock.readLock().lock();
                try {
                    Integer n = ZoneawareEnsemblePlacementPolicyImpl.this.topology.countNumOfAvailableNodes(ZoneawareEnsemblePlacementPolicyImpl.this.getDefaultFaultDomain(), Collections.emptySet());
                    return n;
                }
                finally {
                    ZoneawareEnsemblePlacementPolicyImpl.this.rwLock.readLock().unlock();
                }
            }
        };
        this.statsLogger.registerGauge("NUM_WRITABLE_BOOKIES_IN_DEFAULT_FAULTDOMAIN", this.numWritableBookiesInDefaultFaultDomain);
        this.reorderThresholdPendingRequests = conf.getReorderThresholdPendingRequests();
        this.isWeighted = conf.getDiskWeightBasedPlacementEnabled();
        if (this.isWeighted) {
            this.maxWeightMultiple = conf.getBookieMaxWeightMultipleForWeightBasedPlacement();
            this.weightedSelection = new DynamicWeightedRandomSelectionImpl(this.maxWeightMultiple);
            LOG.info("Weight based placement with max multiple of {}", (Object)this.maxWeightMultiple);
        } else {
            LOG.info("Not weighted");
        }
        this.minNumZonesPerWriteQuorum = conf.getMinNumZonesPerWriteQuorum();
        this.desiredNumZonesPerWriteQuorum = conf.getDesiredNumZonesPerWriteQuorum();
        this.enforceStrictZoneawarePlacement = conf.getEnforceStrictZoneawarePlacement();
        if (this.minNumZonesPerWriteQuorum > this.desiredNumZonesPerWriteQuorum) {
            LOG.error("It is misconfigured, for ZoneawareEnsemblePlacementPolicy, minNumZonesPerWriteQuorum: {} cann't be greater than desiredNumZonesPerWriteQuorum: {}", (Object)this.minNumZonesPerWriteQuorum, (Object)this.desiredNumZonesPerWriteQuorum);
            throw new IllegalArgumentException("minNumZonesPerWriteQuorum: " + this.minNumZonesPerWriteQuorum + " cann't be greater than desiredNumZonesPerWriteQuorum: " + this.desiredNumZonesPerWriteQuorum);
        }
        if (optionalDnsResolver.isPresent()) {
            actualDNSResolver = optionalDnsResolver.get();
        } else {
            String dnsResolverName = conf.getString("reppDnsResolverClass", ScriptBasedMapping.class.getName());
            actualDNSResolver = ReflectionUtils.newInstance(dnsResolverName, DNSToSwitchMapping.class);
            actualDNSResolver.setBookieAddressResolver(bookieAddressResolver);
            if (actualDNSResolver instanceof Configurable) {
                ((Configurable)((Object)actualDNSResolver)).setConf((Configuration)conf);
            }
        }
        this.dnsResolver = new TopologyAwareEnsemblePlacementPolicy.DNSResolverDecorator(actualDNSResolver, () -> this.getDefaultFaultDomain(), this.failedToResolveNetworkLocationCounter);
        this.dnsResolver.setBookieAddressResolver(bookieAddressResolver);
        this.stabilizePeriodSeconds = conf.getNetworkTopologyStabilizePeriodSeconds();
        this.topology = this.stabilizePeriodSeconds > 0 ? new StabilizeNetworkTopology(timer, this.stabilizePeriodSeconds) : new NetworkTopologyImpl();
        try {
            this.myNode = this.createDummyLocalBookieNode(InetAddress.getLocalHost().getHostAddress());
            this.myZone = this.getZoneAwareNodeLocation(this.myNode).getZone();
        }
        catch (IOException e) {
            LOG.error("Failed to get local host address : ", (Throwable)e);
            throw new RuntimeException(e);
        }
        LOG.info("Initialized zoneaware ensemble placement policy @ {} @ {} : {}.", new Object[]{this.myNode, this.myNode.getNetworkLocation(), this.dnsResolver.getClass().getName()});
        this.slowBookies = CacheBuilder.newBuilder().expireAfterWrite(conf.getBookieFailureHistoryExpirationMSec(), TimeUnit.MILLISECONDS).build(new CacheLoader<BookieId, Long>(){

            @Override
            public Long load(BookieId key) throws Exception {
                return -1L;
            }
        });
        return this;
    }

    public ZoneawareEnsemblePlacementPolicyImpl withDefaultFaultDomain(String defaultFaultDomain) {
        Preconditions.checkNotNull(defaultFaultDomain, "Default fault domain cannot be null");
        String[] parts = StringUtils.split(NodeBase.normalize(defaultFaultDomain), '/');
        if (parts.length != 2) {
            LOG.error("provided defaultFaultDomain: {} is not valid", (Object)defaultFaultDomain);
            throw new IllegalArgumentException("invalid defaultFaultDomain");
        }
        this.unresolvedNodeLocation = new ZoneAwareNodeLocation("/" + parts[0], "/" + parts[1]);
        this.defaultFaultDomain = defaultFaultDomain;
        return this;
    }

    public String getDefaultFaultDomain() {
        return this.defaultFaultDomain;
    }

    @Override
    public EnsemblePlacementPolicy.PlacementResult<List<BookieId>> newEnsemble(int ensembleSize, int writeQuorumSize, int ackQuorumSize, Set<BookieId> excludeBookies, ITopologyAwareEnsemblePlacementPolicy.Ensemble<BookieNode> parentEnsemble, ITopologyAwareEnsemblePlacementPolicy.Predicate<BookieNode> parentPredicate) throws BKException.BKNotEnoughBookiesException {
        throw new UnsupportedOperationException("newEnsemble method with parentEnsemble and parentPredicate is not supported for ZoneawareEnsemblePlacementPolicyImpl");
    }

    @Override
    public BookieNode selectFromNetworkLocation(String networkLoc, Set<Node> excludeBookies, ITopologyAwareEnsemblePlacementPolicy.Predicate<BookieNode> predicate, ITopologyAwareEnsemblePlacementPolicy.Ensemble<BookieNode> ensemble, boolean fallbackToRandom) throws BKException.BKNotEnoughBookiesException {
        throw new UnsupportedOperationException("selectFromNetworkLocation is not supported for ZoneawareEnsemblePlacementPolicyImpl");
    }

    @Override
    public BookieNode selectFromNetworkLocation(Set<String> excludeRacks, Set<Node> excludeBookies, ITopologyAwareEnsemblePlacementPolicy.Predicate<BookieNode> predicate, ITopologyAwareEnsemblePlacementPolicy.Ensemble<BookieNode> ensemble, boolean fallbackToRandom) throws BKException.BKNotEnoughBookiesException {
        throw new UnsupportedOperationException("selectFromNetworkLocation is not supported for ZoneawareEnsemblePlacementPolicyImpl");
    }

    @Override
    public BookieNode selectFromNetworkLocation(String networkLoc, Set<String> excludeRacks, Set<Node> excludeBookies, ITopologyAwareEnsemblePlacementPolicy.Predicate<BookieNode> predicate, ITopologyAwareEnsemblePlacementPolicy.Ensemble<BookieNode> ensemble, boolean fallbackToRandom) throws BKException.BKNotEnoughBookiesException {
        throw new UnsupportedOperationException("selectFromNetworkLocation is not supported for ZoneawareEnsemblePlacementPolicyImpl");
    }

    @Override
    public void uninitalize() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EnsemblePlacementPolicy.PlacementResult<List<BookieId>> newEnsemble(int ensembleSize, int writeQuorumSize, int ackQuorumSize, Map<String, byte[]> customMetadata, Set<BookieId> excludeBookies) throws BKException.BKNotEnoughBookiesException {
        if (this.enforceStrictZoneawarePlacement) {
            if (ensembleSize % writeQuorumSize != 0) {
                LOG.error("It is illegal for ensembleSize to be not multiple of writeQuorumSize When StrictZoneawarePlacement is enabled");
                throw new IllegalArgumentException("It is illegal for ensembleSize to be not multiple of writeQuorumSize When StrictZoneawarePlacement is enabled");
            }
            if (writeQuorumSize <= this.minNumZonesPerWriteQuorum) {
                LOG.error("It is illegal for writeQuorumSize to be lesser than or equal to minNumZonesPerWriteQuorum When StrictZoneawarePlacement is enabled");
                throw new IllegalArgumentException("It is illegal for writeQuorumSize to be lesser than or equal to minNumZonesPerWriteQuorum When StrictZoneawarePlacement is enabled");
            }
        }
        int desiredNumZonesPerWriteQuorumForThisEnsemble = Math.min(writeQuorumSize, this.desiredNumZonesPerWriteQuorum);
        ArrayList<Object> newEnsemble = new ArrayList<Object>(Collections.nCopies(ensembleSize, null));
        this.rwLock.readLock().lock();
        try {
            if (!this.enforceStrictZoneawarePlacement) {
                EnsemblePlacementPolicy.PlacementResult<List<BookieId>> placementResult = this.createNewEnsembleRandomly(newEnsemble, writeQuorumSize, ackQuorumSize, customMetadata, excludeBookies);
                return placementResult;
            }
            Set<BookieId> comprehensiveExclusionBookiesSet = this.addDefaultFaultDomainBookies(excludeBookies);
            for (int index = 0; index < ensembleSize; ++index) {
                BookieId selectedBookie = this.setBookieInTheEnsemble(ensembleSize, writeQuorumSize, newEnsemble, newEnsemble, index, desiredNumZonesPerWriteQuorumForThisEnsemble, comprehensiveExclusionBookiesSet);
                comprehensiveExclusionBookiesSet.add(selectedBookie);
            }
            EnsemblePlacementPolicy.PlacementResult<List<BookieId>> placementResult = EnsemblePlacementPolicy.PlacementResult.of(newEnsemble, this.isEnsembleAdheringToPlacementPolicy(newEnsemble, writeQuorumSize, ackQuorumSize));
            return placementResult;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EnsemblePlacementPolicy.PlacementResult<BookieId> replaceBookie(int ensembleSize, int writeQuorumSize, int ackQuorumSize, Map<String, byte[]> customMetadata, List<BookieId> currentEnsemble, BookieId bookieToReplace, Set<BookieId> excludeBookies) throws BKException.BKNotEnoughBookiesException {
        int bookieToReplaceIndex = currentEnsemble.indexOf(bookieToReplace);
        int desiredNumZonesPerWriteQuorumForThisEnsemble = writeQuorumSize < this.desiredNumZonesPerWriteQuorum ? writeQuorumSize : this.desiredNumZonesPerWriteQuorum;
        ArrayList<BookieId> newEnsemble = new ArrayList<BookieId>(currentEnsemble);
        this.rwLock.readLock().lock();
        try {
            if (!this.enforceStrictZoneawarePlacement) {
                EnsemblePlacementPolicy.PlacementResult<BookieId> placementResult = this.selectBookieRandomly(newEnsemble, bookieToReplace, excludeBookies, writeQuorumSize, ackQuorumSize);
                return placementResult;
            }
            Set<BookieId> comprehensiveExclusionBookiesSet = this.addDefaultFaultDomainBookies(excludeBookies);
            comprehensiveExclusionBookiesSet.addAll(currentEnsemble);
            BookieId candidateAddr = this.setBookieInTheEnsemble(ensembleSize, writeQuorumSize, currentEnsemble, newEnsemble, bookieToReplaceIndex, desiredNumZonesPerWriteQuorumForThisEnsemble, comprehensiveExclusionBookiesSet);
            EnsemblePlacementPolicy.PlacementResult<BookieId> placementResult = EnsemblePlacementPolicy.PlacementResult.of(candidateAddr, this.isEnsembleAdheringToPlacementPolicy(newEnsemble, writeQuorumSize, ackQuorumSize));
            return placementResult;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    private EnsemblePlacementPolicy.PlacementResult<List<BookieId>> createNewEnsembleRandomly(List<BookieId> newEnsemble, int writeQuorumSize, int ackQuorumSize, Map<String, byte[]> customMetadata, Set<BookieId> excludeBookies) throws BKException.BKNotEnoughBookiesException {
        int ensembleSize = newEnsemble.size();
        Set<BookieNode> bookiesToConsider = this.getBookiesToConsider(excludeBookies);
        if (bookiesToConsider.size() < newEnsemble.size()) {
            LOG.error("Not enough bookies are available to form ensemble of size: {}", (Object)newEnsemble.size());
            throw new BKException.BKNotEnoughBookiesException();
        }
        for (int i = 0; i < ensembleSize; ++i) {
            BookieNode candidateNode = this.selectCandidateNode(bookiesToConsider);
            newEnsemble.set(i, candidateNode.getAddr());
            bookiesToConsider.remove(candidateNode);
        }
        return EnsemblePlacementPolicy.PlacementResult.of(newEnsemble, this.isEnsembleAdheringToPlacementPolicy(newEnsemble, writeQuorumSize, ackQuorumSize));
    }

    private EnsemblePlacementPolicy.PlacementResult<BookieId> selectBookieRandomly(List<BookieId> newEnsemble, BookieId bookieToReplace, Set<BookieId> excludeBookies, int writeQuorumSize, int ackQuorumSize) throws BKException.BKNotEnoughBookiesException {
        HashSet<BookieId> bookiesToExcludeIncludingEnsemble = new HashSet<BookieId>(excludeBookies);
        bookiesToExcludeIncludingEnsemble.addAll(newEnsemble);
        Set<BookieNode> bookiesToConsider = this.getBookiesToConsider(bookiesToExcludeIncludingEnsemble);
        int bookieToReplaceIndex = newEnsemble.indexOf(bookieToReplace);
        if (bookiesToConsider.isEmpty()) {
            LOG.error("There is no bookie available to replace a bookie");
            throw new BKException.BKNotEnoughBookiesException();
        }
        BookieId candidateAddr = this.selectCandidateNode(bookiesToConsider).getAddr();
        newEnsemble.set(bookieToReplaceIndex, candidateAddr);
        return EnsemblePlacementPolicy.PlacementResult.of(candidateAddr, this.isEnsembleAdheringToPlacementPolicy(newEnsemble, writeQuorumSize, ackQuorumSize));
    }

    private Set<BookieNode> getBookiesToConsider(Set<BookieId> excludeBookies) {
        Set<Node> leaves = this.topology.getLeaves("");
        HashSet<BookieNode> bookiesToConsider = new HashSet<BookieNode>();
        for (Node leaf : leaves) {
            BookieNode bookieNode;
            if (!(leaf instanceof BookieNode) || excludeBookies.contains((bookieNode = (BookieNode)leaf).getAddr())) continue;
            bookiesToConsider.add(bookieNode);
        }
        return bookiesToConsider;
    }

    private BookieId setBookieInTheEnsemble(int ensembleSize, int writeQuorumSize, List<BookieId> currentEnsemble, List<BookieId> newEnsemble, int bookieToReplaceIndex, int desiredNumZonesPerWriteQuorumForThisEnsemble, Set<BookieId> excludeBookies) throws BKException.BKNotEnoughBookiesException {
        BookieId bookieToReplace = currentEnsemble.get(bookieToReplaceIndex);
        Set<String> zonesToExclude = null;
        Set<BookieNode> bookiesToConsiderAfterExcludingZonesAndUDs = null;
        for (int numberOfNeighborsToConsider = desiredNumZonesPerWriteQuorumForThisEnsemble - 1; numberOfNeighborsToConsider >= this.minNumZonesPerWriteQuorum - 1 && (bookiesToConsiderAfterExcludingZonesAndUDs = this.getBookiesToConsiderAfterExcludingZonesAndUDs(ensembleSize, writeQuorumSize, currentEnsemble, bookieToReplaceIndex, excludeBookies, zonesToExclude = this.getZonesOfNeighboringNodesInEnsemble(currentEnsemble, bookieToReplaceIndex, numberOfNeighborsToConsider))).isEmpty(); --numberOfNeighborsToConsider) {
        }
        if (bookiesToConsiderAfterExcludingZonesAndUDs.isEmpty()) {
            zonesToExclude = this.getZonesToExcludeToMaintainMinZones(currentEnsemble, bookieToReplaceIndex, writeQuorumSize);
            bookiesToConsiderAfterExcludingZonesAndUDs = this.getBookiesToConsiderAfterExcludingZonesAndUDs(ensembleSize, writeQuorumSize, currentEnsemble, bookieToReplaceIndex, excludeBookies, zonesToExclude);
        }
        if (bookiesToConsiderAfterExcludingZonesAndUDs.isEmpty()) {
            LOG.error("Not enough bookies are available to replaceBookie : {} in ensemble : {} with excludeBookies {}.", new Object[]{bookieToReplace, currentEnsemble, excludeBookies});
            throw new BKException.BKNotEnoughBookiesException();
        }
        BookieId candidateAddr = this.selectCandidateNode(bookiesToConsiderAfterExcludingZonesAndUDs).getAddr();
        newEnsemble.set(bookieToReplaceIndex, candidateAddr);
        return candidateAddr;
    }

    protected Set<BookieId> addDefaultFaultDomainBookies(Set<BookieId> excludeBookies) {
        HashSet<BookieId> comprehensiveExclusionBookiesSet = new HashSet<BookieId>(excludeBookies);
        Set<Node> defaultFaultDomainLeaves = this.topology.getLeaves(this.getDefaultFaultDomain());
        for (Node node : defaultFaultDomainLeaves) {
            if (node instanceof BookieNode) {
                comprehensiveExclusionBookiesSet.add(((BookieNode)node).getAddr());
                continue;
            }
            LOG.error("found non-BookieNode: {} as leaf of defaultFaultDomain: {}", (Object)node, (Object)this.getDefaultFaultDomain());
        }
        return comprehensiveExclusionBookiesSet;
    }

    private BookieNode selectCandidateNode(Set<BookieNode> bookiesToConsiderAfterExcludingUDs) {
        BookieNode candidate = null;
        if (!this.isWeighted) {
            int randSelIndex = this.rand.nextInt(bookiesToConsiderAfterExcludingUDs.size());
            int ind = 0;
            for (BookieNode bookieNode : bookiesToConsiderAfterExcludingUDs) {
                if (ind == randSelIndex) {
                    candidate = bookieNode;
                    break;
                }
                ++ind;
            }
        } else {
            candidate = this.weightedSelection.getNextRandom(bookiesToConsiderAfterExcludingUDs);
        }
        return candidate;
    }

    private String getExcludedZonesString(Set<String> excludeZones) {
        if (excludeZones.isEmpty()) {
            return "";
        }
        StringBuilder excludedZonesString = new StringBuilder("~");
        boolean firstZone = true;
        for (String excludeZone : excludeZones) {
            if (!firstZone) {
                excludedZonesString.append(",");
            }
            excludedZonesString.append(excludeZone);
            firstZone = false;
        }
        return excludedZonesString.toString();
    }

    private Set<BookieNode> getBookiesToConsider(String excludedZonesString, Set<BookieId> excludeBookies) {
        HashSet<BookieNode> bookiesToConsider = new HashSet<BookieNode>();
        Set<Node> leaves = this.topology.getLeaves(excludedZonesString);
        for (Node leaf : leaves) {
            BookieNode bookieNode = (BookieNode)leaf;
            if (excludeBookies.contains(bookieNode.getAddr())) continue;
            bookiesToConsider.add(bookieNode);
        }
        return bookiesToConsider;
    }

    private Set<BookieNode> getBookiesToConsiderAfterExcludingZonesAndUDs(int ensembleSize, int writeQuorumSize, List<BookieId> currentEnsemble, int bookieToReplaceIndex, Set<BookieId> excludeBookies, Set<String> excludeZones) {
        HashSet<BookieNode> bookiesToConsiderAfterExcludingZonesAndUDs = new HashSet<BookieNode>();
        HashMap<String, Set<String>> excludingUDsOfZonesToConsider = new HashMap<String, Set<String>>();
        Set<BookieNode> bookiesToConsiderAfterExcludingZones = this.getBookiesToConsider(this.getExcludedZonesString(excludeZones), excludeBookies);
        if (!bookiesToConsiderAfterExcludingZones.isEmpty()) {
            Set<String> zonesToConsider = this.getZonesOfBookies(bookiesToConsiderAfterExcludingZones);
            for (String zoneToConsider : zonesToConsider) {
                Set<String> upgradeDomainsOfAZoneInNeighboringNodes = this.getUpgradeDomainsOfAZoneInNeighboringNodes(currentEnsemble, bookieToReplaceIndex, writeQuorumSize, zoneToConsider);
                excludingUDsOfZonesToConsider.put(zoneToConsider, upgradeDomainsOfAZoneInNeighboringNodes);
            }
            this.updateBookiesToConsiderAfterExcludingZonesAndUDs(bookiesToConsiderAfterExcludingZonesAndUDs, bookiesToConsiderAfterExcludingZones, excludingUDsOfZonesToConsider);
            if (bookiesToConsiderAfterExcludingZonesAndUDs.isEmpty()) {
                excludingUDsOfZonesToConsider.clear();
                for (String zoneToConsider : zonesToConsider) {
                    Set<String> udsToExcludeToMaintainMinUDsInWriteQuorums = this.getUDsToExcludeToMaintainMinUDsInWriteQuorums(currentEnsemble, bookieToReplaceIndex, writeQuorumSize, zoneToConsider);
                    excludingUDsOfZonesToConsider.put(zoneToConsider, udsToExcludeToMaintainMinUDsInWriteQuorums);
                }
                this.updateBookiesToConsiderAfterExcludingZonesAndUDs(bookiesToConsiderAfterExcludingZonesAndUDs, bookiesToConsiderAfterExcludingZones, excludingUDsOfZonesToConsider);
            }
        }
        return bookiesToConsiderAfterExcludingZonesAndUDs;
    }

    private void updateBookiesToConsiderAfterExcludingZonesAndUDs(Set<BookieNode> bookiesToConsiderAfterExcludingUDs, Set<BookieNode> bookiesToConsider, HashMap<String, Set<String>> excludingUDsOfZonesToConsider) {
        for (BookieNode bookieToConsider : bookiesToConsider) {
            ZoneAwareNodeLocation nodeLocation = this.getZoneAwareNodeLocation(bookieToConsider);
            if (excludingUDsOfZonesToConsider.get(nodeLocation.getZone()).contains(nodeLocation.getUpgradeDomain())) continue;
            bookiesToConsiderAfterExcludingUDs.add(bookieToConsider);
        }
    }

    private Set<String> getZonesOfNeighboringNodesInEnsemble(List<BookieId> currentEnsemble, int indexOfNode, int numOfNeighboringNodes) {
        HashSet<String> zonesOfNeighboringNodes = new HashSet<String>();
        int ensembleSize = currentEnsemble.size();
        for (int i = -1 * numOfNeighboringNodes; i <= numOfNeighboringNodes; ++i) {
            int index;
            BookieId addrofNode;
            if (i == 0 || (addrofNode = currentEnsemble.get(index = (indexOfNode + i + ensembleSize) % ensembleSize)) == null) continue;
            String zoneOfNode = this.getZoneAwareNodeLocation(addrofNode).getZone();
            zonesOfNeighboringNodes.add(zoneOfNode);
        }
        return zonesOfNeighboringNodes;
    }

    private Set<String> getZonesToExcludeToMaintainMinZones(List<BookieId> currentEnsemble, int indexOfNode, int writeQuorumSize) {
        int ensSize = currentEnsemble.size();
        HashSet<String> zonesToExclude = new HashSet<String>();
        HashSet<String> zonesInWriteQuorum = new HashSet<String>();
        for (int i = -(writeQuorumSize - 1); i <= 0; ++i) {
            zonesInWriteQuorum.clear();
            for (int j = 0; j < writeQuorumSize; ++j) {
                BookieId bookieAddr;
                int indexInEnsemble = (i + j + indexOfNode + ensSize) % ensSize;
                if (indexInEnsemble == indexOfNode || (bookieAddr = currentEnsemble.get(indexInEnsemble)) == null) continue;
                ZoneAwareNodeLocation nodeLocation = this.getZoneAwareNodeLocation(bookieAddr);
                zonesInWriteQuorum.add(nodeLocation.getZone());
            }
            if (zonesInWriteQuorum.size() > this.minNumZonesPerWriteQuorum - 1) continue;
            zonesToExclude.addAll(zonesInWriteQuorum);
        }
        return zonesToExclude;
    }

    private Set<String> getZonesOfBookies(Collection<BookieNode> bookieNodes) {
        HashSet<String> zonesOfBookies = new HashSet<String>();
        for (BookieNode bookieNode : bookieNodes) {
            ZoneAwareNodeLocation nodeLocation = this.getZoneAwareNodeLocation(bookieNode);
            zonesOfBookies.add(nodeLocation.getZone());
        }
        return zonesOfBookies;
    }

    private Set<String> getUpgradeDomainsOfAZoneInNeighboringNodes(List<BookieId> currentEnsemble, int indexOfNode, int writeQuorumSize, String zone) {
        int ensSize = currentEnsemble.size();
        HashSet<String> upgradeDomainsOfAZoneInNeighboringNodes = new HashSet<String>();
        for (int i = -(writeQuorumSize - 1); i <= writeQuorumSize - 1; ++i) {
            ZoneAwareNodeLocation nodeLocation;
            int indexInEnsemble;
            BookieId bookieAddr;
            if (i == 0 || (bookieAddr = currentEnsemble.get(indexInEnsemble = (indexOfNode + i + ensSize) % ensSize)) == null || !(nodeLocation = this.getZoneAwareNodeLocation(bookieAddr)).getZone().equals(zone)) continue;
            upgradeDomainsOfAZoneInNeighboringNodes.add(nodeLocation.getUpgradeDomain());
        }
        return upgradeDomainsOfAZoneInNeighboringNodes;
    }

    private Set<String> getUDsToExcludeToMaintainMinUDsInWriteQuorums(List<BookieId> currentEnsemble, int indexOfNode, int writeQuorumSize, String zone) {
        int ensSize = currentEnsemble.size();
        HashSet<String> upgradeDomainsToExclude = new HashSet<String>();
        HashSet<String> upgradeDomainsOfThisZoneInWriteQuorum = new HashSet<String>();
        for (int i = -(writeQuorumSize - 1); i <= 0; ++i) {
            upgradeDomainsOfThisZoneInWriteQuorum.clear();
            for (int j = 0; j < writeQuorumSize; ++j) {
                ZoneAwareNodeLocation nodeLocation;
                BookieId bookieAddr;
                int indexInEnsemble = (i + j + indexOfNode + ensSize) % ensSize;
                if (indexInEnsemble == indexOfNode || (bookieAddr = currentEnsemble.get(indexInEnsemble)) == null || !(nodeLocation = this.getZoneAwareNodeLocation(bookieAddr)).getZone().equals(zone)) continue;
                upgradeDomainsOfThisZoneInWriteQuorum.add(nodeLocation.getUpgradeDomain());
            }
            if (upgradeDomainsOfThisZoneInWriteQuorum.size() != 1) continue;
            upgradeDomainsToExclude.addAll(upgradeDomainsOfThisZoneInWriteQuorum);
        }
        return upgradeDomainsToExclude;
    }

    @Override
    public void registerSlowBookie(BookieId bookieSocketAddress, long entryId) {
    }

    @Override
    public DistributionSchedule.WriteSet reorderReadSequence(List<BookieId> ensemble, BookiesHealthInfo bookiesHealthInfo, DistributionSchedule.WriteSet writeSet) {
        return writeSet;
    }

    @Override
    public DistributionSchedule.WriteSet reorderReadLACSequence(List<BookieId> ensemble, BookiesHealthInfo bookiesHealthInfo, DistributionSchedule.WriteSet writeSet) {
        DistributionSchedule.WriteSet retList = this.reorderReadSequence(ensemble, bookiesHealthInfo, writeSet);
        retList.addMissingIndices(ensemble.size());
        return retList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EnsemblePlacementPolicy.PlacementPolicyAdherence isEnsembleAdheringToPlacementPolicy(List<BookieId> ensembleList, int writeQuorumSize, int ackQuorumSize) {
        if (CollectionUtils.isEmpty(ensembleList)) {
            return EnsemblePlacementPolicy.PlacementPolicyAdherence.FAIL;
        }
        EnsemblePlacementPolicy.PlacementPolicyAdherence placementPolicyAdherence = EnsemblePlacementPolicy.PlacementPolicyAdherence.MEETS_STRICT;
        this.rwLock.readLock().lock();
        try {
            HashMap<String, Set<String>> bookiesLocationInWriteSet = new HashMap<String, Set<String>>();
            HashMap<String, Integer> numOfBookiesInZones = new HashMap<String, Integer>();
            if (ensembleList.size() % writeQuorumSize != 0) {
                placementPolicyAdherence = EnsemblePlacementPolicy.PlacementPolicyAdherence.FAIL;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("For ensemble: {}, ensembleSize: {} is not a multiple of writeQuorumSize: {}", new Object[]{ensembleList, ensembleList.size(), writeQuorumSize});
                }
                EnsemblePlacementPolicy.PlacementPolicyAdherence placementPolicyAdherence2 = placementPolicyAdherence;
                return placementPolicyAdherence2;
            }
            if (writeQuorumSize <= this.minNumZonesPerWriteQuorum) {
                placementPolicyAdherence = EnsemblePlacementPolicy.PlacementPolicyAdherence.FAIL;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("For ensemble: {}, writeQuorumSize: {} is less than or equal to minNumZonesPerWriteQuorum: {}", new Object[]{ensembleList, writeQuorumSize, this.minNumZonesPerWriteQuorum});
                }
                EnsemblePlacementPolicy.PlacementPolicyAdherence placementPolicyAdherence3 = placementPolicyAdherence;
                return placementPolicyAdherence3;
            }
            int desiredNumZonesPerWriteQuorumForThisEnsemble = Math.min(writeQuorumSize, this.desiredNumZonesPerWriteQuorum);
            for (int i = 0; i < ensembleList.size(); ++i) {
                bookiesLocationInWriteSet.clear();
                numOfBookiesInZones.clear();
                for (int j = 0; j < writeQuorumSize; ++j) {
                    int indexOfNode = (i + j) % ensembleList.size();
                    BookieId bookieNode = ensembleList.get(indexOfNode);
                    ZoneAwareNodeLocation nodeLocation = this.getZoneAwareNodeLocation(bookieNode);
                    if (nodeLocation.equals(this.unresolvedNodeLocation)) {
                        placementPolicyAdherence = EnsemblePlacementPolicy.PlacementPolicyAdherence.FAIL;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("ensemble: {}, contains bookie: {} for which network location is unresolvable", ensembleList, (Object)bookieNode);
                        }
                        EnsemblePlacementPolicy.PlacementPolicyAdherence placementPolicyAdherence4 = placementPolicyAdherence;
                        return placementPolicyAdherence4;
                    }
                    String zone = nodeLocation.getZone();
                    String upgradeDomain = nodeLocation.getUpgradeDomain();
                    Set<String> udsOfThisZoneInThisWriteSet = bookiesLocationInWriteSet.get(zone);
                    if (udsOfThisZoneInThisWriteSet == null) {
                        udsOfThisZoneInThisWriteSet = new HashSet<String>();
                        udsOfThisZoneInThisWriteSet.add(upgradeDomain);
                        bookiesLocationInWriteSet.put(zone, udsOfThisZoneInThisWriteSet);
                        numOfBookiesInZones.put(zone, 1);
                        continue;
                    }
                    udsOfThisZoneInThisWriteSet.add(upgradeDomain);
                    Integer numOfNodesInAZone = numOfBookiesInZones.get(zone);
                    numOfBookiesInZones.put(zone, numOfNodesInAZone + 1);
                }
                if (numOfBookiesInZones.entrySet().size() < this.minNumZonesPerWriteQuorum) {
                    placementPolicyAdherence = EnsemblePlacementPolicy.PlacementPolicyAdherence.FAIL;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("in ensemble: {}, writeset starting at: {} doesn't contain bookies from minNumZonesPerWriteQuorum: {}", new Object[]{ensembleList, i, this.minNumZonesPerWriteQuorum});
                    }
                    EnsemblePlacementPolicy.PlacementPolicyAdherence placementPolicyAdherence5 = placementPolicyAdherence;
                    return placementPolicyAdherence5;
                }
                if (numOfBookiesInZones.entrySet().size() >= desiredNumZonesPerWriteQuorumForThisEnsemble) {
                    if (this.validateMinUDsAreMaintained(numOfBookiesInZones, bookiesLocationInWriteSet)) continue;
                    placementPolicyAdherence = EnsemblePlacementPolicy.PlacementPolicyAdherence.FAIL;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("in ensemble: {}, writeset starting at: {} doesn't maintain min of 2 UDs when there are multiple bookies from the same zone.", ensembleList, (Object)i);
                    }
                    EnsemblePlacementPolicy.PlacementPolicyAdherence placementPolicyAdherence6 = placementPolicyAdherence;
                    return placementPolicyAdherence6;
                }
                if (!this.validateMinUDsAreMaintained(numOfBookiesInZones, bookiesLocationInWriteSet)) {
                    placementPolicyAdherence = EnsemblePlacementPolicy.PlacementPolicyAdherence.FAIL;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("in ensemble: {}, writeset starting at: {} doesn't maintain min of 2 UDs when there are multiple bookies from the same zone.", ensembleList, (Object)i);
                    }
                    EnsemblePlacementPolicy.PlacementPolicyAdherence placementPolicyAdherence7 = placementPolicyAdherence;
                    return placementPolicyAdherence7;
                }
                if (placementPolicyAdherence != EnsemblePlacementPolicy.PlacementPolicyAdherence.MEETS_STRICT) continue;
                placementPolicyAdherence = EnsemblePlacementPolicy.PlacementPolicyAdherence.MEETS_SOFT;
            }
        }
        finally {
            this.rwLock.readLock().unlock();
        }
        return placementPolicyAdherence;
    }

    private boolean validateMinUDsAreMaintained(HashMap<String, Integer> numOfNodesInZones, HashMap<String, Set<String>> nodesLocationInWriteSet) {
        for (Map.Entry<String, Integer> numOfNodesInZone : numOfNodesInZones.entrySet()) {
            Set<String> udsOfThisZone;
            String zone = numOfNodesInZone.getKey();
            Integer numOfNodesInThisZone = numOfNodesInZone.getValue();
            if (numOfNodesInThisZone <= 1 || (udsOfThisZone = nodesLocationInWriteSet.get(zone)).size() >= 2) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean areAckedBookiesAdheringToPlacementPolicy(Set<BookieId> ackedBookies, int writeQuorumSize, int ackQuorumSize) {
        HashSet<String> zonesOfAckedBookies = new HashSet<String>();
        int minNumZonesPerWriteQuorumForThisEnsemble = Math.min(writeQuorumSize, this.minNumZonesPerWriteQuorum);
        boolean areAckedBookiesAdheringToPlacementPolicy = false;
        ReentrantReadWriteLock.ReadLock readLock = this.rwLock.readLock();
        readLock.lock();
        try {
            for (BookieId ackedBookie : ackedBookies) {
                zonesOfAckedBookies.add(this.getZoneAwareNodeLocation(ackedBookie).getZone());
            }
            boolean bl = areAckedBookiesAdheringToPlacementPolicy = zonesOfAckedBookies.size() >= minNumZonesPerWriteQuorumForThisEnsemble && ackedBookies.size() >= ackQuorumSize;
            if (LOG.isDebugEnabled()) {
                LOG.debug("areAckedBookiesAdheringToPlacementPolicy returning {}, because number of ackedBookies = {}, number of Zones of ackedbookies = {}, number of minNumZonesPerWriteQuorumForThisEnsemble = {}", new Object[]{areAckedBookiesAdheringToPlacementPolicy, ackedBookies.size(), zonesOfAckedBookies.size(), minNumZonesPerWriteQuorumForThisEnsemble});
            }
        }
        finally {
            readLock.unlock();
        }
        return areAckedBookiesAdheringToPlacementPolicy;
    }

    public static class ZoneAwareNodeLocation {
        private final String zone;
        private final String upgradeDomain;
        private final String repString;

        public ZoneAwareNodeLocation(String zone, String upgradeDomain) {
            this.zone = zone;
            this.upgradeDomain = upgradeDomain;
            this.repString = zone + upgradeDomain;
        }

        public String getZone() {
            return this.zone;
        }

        public String getUpgradeDomain() {
            return this.upgradeDomain;
        }

        public int hashCode() {
            return this.repString.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof ZoneAwareNodeLocation && this.repString.equals(((ZoneAwareNodeLocation)obj).repString);
        }
    }
}

