/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.bookkeeper.common.collections;

import dlshade.org.apache.bookkeeper.util.MathUtils;
import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.StampedLock;

public class GrowableMpScArrayConsumerBlockingQueue<T>
extends AbstractQueue<T>
implements BlockingQueue<T> {
    private final StampedLock headLock = new StampedLock();
    private final PaddedInt headIndex = new PaddedInt();
    private final PaddedInt tailIndex = new PaddedInt();
    private final StampedLock tailLock = new StampedLock();
    private T[] data;
    private final AtomicInteger size = new AtomicInteger(0);
    private volatile Thread waitingConsumer;

    public GrowableMpScArrayConsumerBlockingQueue() {
        this(64);
    }

    public GrowableMpScArrayConsumerBlockingQueue(int initialCapacity) {
        int capacity = MathUtils.findNextPositivePowerOfTwo(initialCapacity);
        this.data = new Object[capacity];
    }

    @Override
    public T remove() {
        T item = this.poll();
        if (item == null) {
            throw new NoSuchElementException();
        }
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T poll() {
        if (this.size.get() > 0) {
            long stamp = this.headLock.readLock();
            try {
                T item = this.data[this.headIndex.value];
                this.data[this.headIndex.value] = null;
                this.headIndex.value = this.headIndex.value + 1 & this.data.length - 1;
                this.size.decrementAndGet();
                T t = item;
                return t;
            }
            finally {
                this.headLock.unlockRead(stamp);
            }
        }
        return null;
    }

    @Override
    public T element() {
        T item = this.peek();
        if (item == null) {
            throw new NoSuchElementException();
        }
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T peek() {
        if (this.size.get() > 0) {
            long stamp = this.headLock.readLock();
            try {
                T t = this.data[this.headIndex.value];
                return t;
            }
            finally {
                this.headLock.unlockRead(stamp);
            }
        }
        return null;
    }

    @Override
    public boolean offer(T e) {
        this.put(e);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(T e) {
        long stamp = this.tailLock.writeLock();
        try {
            int oldSize = this.size.get();
            if (oldSize == this.data.length) {
                this.expandArray();
            }
            this.data[this.tailIndex.value] = e;
            this.tailIndex.value = this.tailIndex.value + 1 & this.data.length - 1;
            if (this.size.getAndIncrement() == 0 && this.waitingConsumer != null) {
                Thread waitingConsumer = this.waitingConsumer;
                this.waitingConsumer = null;
                LockSupport.unpark(waitingConsumer);
            }
        }
        finally {
            this.tailLock.unlockWrite(stamp);
        }
    }

    @Override
    public boolean add(T e) {
        this.put(e);
        return true;
    }

    @Override
    public boolean offer(T e, long timeout, TimeUnit unit) {
        this.put(e);
        return true;
    }

    @Override
    public T take() throws InterruptedException {
        while (this.size() == 0) {
            this.waitingConsumer = Thread.currentThread();
            if (this.size() != 0) continue;
            LockSupport.park();
            if (!Thread.interrupted()) continue;
            throw new InterruptedException();
        }
        return this.poll();
    }

    @Override
    public T poll(long timeout, TimeUnit unit) throws InterruptedException {
        long deadline = System.currentTimeMillis() + unit.toMillis(timeout);
        while (this.size.get() == 0) {
            this.waitingConsumer = Thread.currentThread();
            if (this.size.get() != 0) continue;
            LockSupport.parkUntil(deadline);
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            if (System.currentTimeMillis() < deadline) continue;
            return null;
        }
        return this.poll();
    }

    @Override
    public int remainingCapacity() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int drainTo(Collection<? super T> c) {
        return this.drainTo(c, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super T> c, int maxElements) {
        long stamp = this.headLock.readLock();
        try {
            int toDrain = Math.min(this.size.get(), maxElements);
            for (int i = 0; i < toDrain; ++i) {
                T item = this.data[this.headIndex.value];
                this.data[this.headIndex.value] = null;
                c.add(item);
                this.headIndex.value = this.headIndex.value + 1 & this.data.length - 1;
            }
            this.size.addAndGet(-toDrain);
            int n = toDrain;
            return n;
        }
        finally {
            this.headLock.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        long stamp = this.headLock.readLock();
        try {
            int size = this.size.get();
            for (int i = 0; i < size; ++i) {
                this.data[this.headIndex.value] = null;
                this.headIndex.value = this.headIndex.value + 1 & this.data.length - 1;
            }
            this.size.addAndGet(-size);
        }
        finally {
            this.headLock.unlockRead(stamp);
        }
    }

    @Override
    public int size() {
        return this.size.get();
    }

    @Override
    public Iterator<T> iterator() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        long tailStamp = this.tailLock.writeLock();
        long headStamp = this.headLock.writeLock();
        try {
            int headIndex = this.headIndex.value;
            int size = this.size.get();
            sb.append('[');
            for (int i = 0; i < size; ++i) {
                T item = this.data[headIndex];
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(item);
                headIndex = headIndex + 1 & this.data.length - 1;
            }
            sb.append(']');
        }
        finally {
            this.headLock.unlockWrite(headStamp);
            this.tailLock.unlockWrite(tailStamp);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expandArray() {
        long headLockStamp = this.headLock.writeLock();
        try {
            int size = this.size.get();
            int newCapacity = this.data.length * 2;
            Object[] newData = new Object[newCapacity];
            int oldHeadIndex = this.headIndex.value;
            int lenHeadToEnd = Math.min(size, this.data.length - oldHeadIndex);
            System.arraycopy(this.data, oldHeadIndex, newData, 0, lenHeadToEnd);
            System.arraycopy(this.data, 0, newData, lenHeadToEnd, size - lenHeadToEnd);
            this.data = newData;
            this.headIndex.value = 0;
            this.tailIndex.value = size;
        }
        finally {
            this.headLock.unlockWrite(headLockStamp);
        }
    }

    private static final class PaddedInt {
        int value = 0;
        public volatile int pi1 = 1;
        public volatile long p1 = 1L;
        public volatile long p2 = 2L;
        public volatile long p3 = 3L;
        public volatile long p4 = 4L;
        public volatile long p5 = 5L;
        public volatile long p6 = 6L;

        private PaddedInt() {
        }

        public long exposeToAvoidOptimization() {
            return (long)this.pi1 + this.p1 + this.p2 + this.p3 + this.p4 + this.p5 + this.p6;
        }
    }
}

