/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.bookkeeper.common.util;

import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;

public class Backoff {
    public static final Policy DEFAULT = Jitter.of(Jitter.Type.EXPONENTIAL, 200L, 2000L, 3L);
    private static final int MaxBitShift = 62;

    public static Stream<Long> constant(long startMs) {
        return Stream.iterate(startMs, lastMs -> startMs);
    }

    public static Stream<Long> exponential(long startMs, int multiplier, long maxMs) {
        return Stream.iterate(startMs, lastMs -> Math.min(lastMs * (long)multiplier, maxMs));
    }

    public static Stream<Long> exponentialJittered(long startMs, long maxMs) {
        long startNanos = TimeUnit.NANOSECONDS.convert(startMs, TimeUnit.MILLISECONDS);
        long maxNanos = TimeUnit.NANOSECONDS.convert(maxMs, TimeUnit.MILLISECONDS);
        AtomicLong attempts = new AtomicLong(1L);
        return Stream.iterate(startMs, lastMs -> {
            long shift = Math.min(attempts.get(), 62L);
            long maxBackoffNanos = Math.min(maxNanos, startNanos * (1L << (int)shift));
            long randomMs = TimeUnit.MILLISECONDS.convert(ThreadLocalRandom.current().nextLong(startNanos, maxBackoffNanos), TimeUnit.NANOSECONDS);
            attempts.incrementAndGet();
            return randomMs;
        });
    }

    public static Stream<Long> decorrelatedJittered(long startMs, long maxMs) {
        long startNanos = TimeUnit.NANOSECONDS.convert(startMs, TimeUnit.MILLISECONDS);
        long maxNanos = TimeUnit.NANOSECONDS.convert(maxMs, TimeUnit.MILLISECONDS);
        return Stream.iterate(startMs, lastMs -> {
            long lastNanos = TimeUnit.MILLISECONDS.convert((long)lastMs, TimeUnit.NANOSECONDS);
            long randRange = Math.abs(lastNanos * 3L - startNanos);
            long randBackoff = 0L == randRange ? startNanos : startNanos + ThreadLocalRandom.current().nextLong(randRange);
            long backOffNanos = Math.min(maxNanos, randBackoff);
            return TimeUnit.MILLISECONDS.convert(backOffNanos, TimeUnit.NANOSECONDS);
        });
    }

    public static Stream<Long> equalJittered(long startMs, long maxMs) {
        long startNanos = TimeUnit.NANOSECONDS.convert(startMs, TimeUnit.MILLISECONDS);
        long maxNanos = TimeUnit.NANOSECONDS.convert(maxMs, TimeUnit.MILLISECONDS);
        AtomicLong attempts = new AtomicLong(1L);
        return Stream.iterate(startMs, lastMs -> {
            long shift = Math.min(attempts.get() - 1L, 62L);
            long halfExpNanos = startNanos * (1L << (int)shift);
            long backoffNanos = halfExpNanos + ThreadLocalRandom.current().nextLong(halfExpNanos);
            attempts.incrementAndGet();
            if (backoffNanos < maxNanos) {
                return TimeUnit.MILLISECONDS.convert(backoffNanos, TimeUnit.NANOSECONDS);
            }
            return maxMs;
        });
    }

    public static class Exponential
    implements Policy {
        private final long startMs;
        private final long maxMs;
        private final int multiplier;
        private final int limit;

        public static Exponential of(long startMs, long maxMs, int multiplier) {
            return Exponential.of(startMs, maxMs, multiplier, -1);
        }

        @Override
        public Stream<Long> toBackoffs() {
            if (this.limit >= 0) {
                return Backoff.exponential(this.startMs, this.multiplier, this.maxMs).limit(this.limit);
            }
            return Backoff.exponential(this.startMs, this.multiplier, this.maxMs);
        }

        private Exponential(long startMs, long maxMs, int multiplier, int limit) {
            this.startMs = startMs;
            this.maxMs = maxMs;
            this.multiplier = multiplier;
            this.limit = limit;
        }

        public static Exponential of(long startMs, long maxMs, int multiplier, int limit) {
            return new Exponential(startMs, maxMs, multiplier, limit);
        }

        public long getStartMs() {
            return this.startMs;
        }

        public long getMaxMs() {
            return this.maxMs;
        }

        public int getMultiplier() {
            return this.multiplier;
        }

        public int getLimit() {
            return this.limit;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Exponential)) {
                return false;
            }
            Exponential other = (Exponential)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getStartMs() != other.getStartMs()) {
                return false;
            }
            if (this.getMaxMs() != other.getMaxMs()) {
                return false;
            }
            if (this.getMultiplier() != other.getMultiplier()) {
                return false;
            }
            return this.getLimit() == other.getLimit();
        }

        protected boolean canEqual(Object other) {
            return other instanceof Exponential;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $startMs = this.getStartMs();
            result = result * 59 + (int)($startMs >>> 32 ^ $startMs);
            long $maxMs = this.getMaxMs();
            result = result * 59 + (int)($maxMs >>> 32 ^ $maxMs);
            result = result * 59 + this.getMultiplier();
            result = result * 59 + this.getLimit();
            return result;
        }

        public String toString() {
            return "Backoff.Exponential(startMs=" + this.getStartMs() + ", maxMs=" + this.getMaxMs() + ", multiplier=" + this.getMultiplier() + ", limit=" + this.getLimit() + ")";
        }
    }

    public static class Jitter
    implements Policy {
        private final Type type;
        private final long startMs;
        private final long maxMs;
        private final long limit;

        public static Jitter of(Type type, long startMs, long maxMs) {
            return Jitter.of(type, startMs, maxMs, -1L);
        }

        @Override
        public Stream<Long> toBackoffs() {
            Stream<Long> backoffStream;
            switch (this.type) {
                case DECORRELATED: {
                    backoffStream = Backoff.decorrelatedJittered(this.startMs, this.maxMs);
                    break;
                }
                case EQUAL: {
                    backoffStream = Backoff.equalJittered(this.startMs, this.maxMs);
                    break;
                }
                default: {
                    backoffStream = Backoff.exponentialJittered(this.startMs, this.maxMs);
                }
            }
            if (this.limit >= 0L) {
                return backoffStream.limit(this.limit);
            }
            return backoffStream;
        }

        private Jitter(Type type, long startMs, long maxMs, long limit) {
            this.type = type;
            this.startMs = startMs;
            this.maxMs = maxMs;
            this.limit = limit;
        }

        public static Jitter of(Type type, long startMs, long maxMs, long limit) {
            return new Jitter(type, startMs, maxMs, limit);
        }

        public Type getType() {
            return this.type;
        }

        public long getStartMs() {
            return this.startMs;
        }

        public long getMaxMs() {
            return this.maxMs;
        }

        public long getLimit() {
            return this.limit;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Jitter)) {
                return false;
            }
            Jitter other = (Jitter)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getStartMs() != other.getStartMs()) {
                return false;
            }
            if (this.getMaxMs() != other.getMaxMs()) {
                return false;
            }
            if (this.getLimit() != other.getLimit()) {
                return false;
            }
            Type this$type = this.getType();
            Type other$type = other.getType();
            return !(this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Jitter;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $startMs = this.getStartMs();
            result = result * 59 + (int)($startMs >>> 32 ^ $startMs);
            long $maxMs = this.getMaxMs();
            result = result * 59 + (int)($maxMs >>> 32 ^ $maxMs);
            long $limit = this.getLimit();
            result = result * 59 + (int)($limit >>> 32 ^ $limit);
            Type $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            return result;
        }

        public String toString() {
            return "Backoff.Jitter(type=" + (Object)((Object)this.getType()) + ", startMs=" + this.getStartMs() + ", maxMs=" + this.getMaxMs() + ", limit=" + this.getLimit() + ")";
        }

        public static enum Type {
            DECORRELATED,
            EQUAL,
            EXPONENTIAL;

        }
    }

    public static class Constant
    implements Policy {
        private final long ms;
        private final long limit;

        public static Constant of(long ms) {
            return Constant.of(ms, -1L);
        }

        @Override
        public Stream<Long> toBackoffs() {
            if (this.limit >= 0L) {
                return Backoff.constant(this.ms).limit(this.limit);
            }
            return Backoff.constant(this.ms);
        }

        private Constant(long ms, long limit) {
            this.ms = ms;
            this.limit = limit;
        }

        public static Constant of(long ms, long limit) {
            return new Constant(ms, limit);
        }

        public long getMs() {
            return this.ms;
        }

        public long getLimit() {
            return this.limit;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Constant)) {
                return false;
            }
            Constant other = (Constant)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getMs() != other.getMs()) {
                return false;
            }
            return this.getLimit() == other.getLimit();
        }

        protected boolean canEqual(Object other) {
            return other instanceof Constant;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $ms = this.getMs();
            result = result * 59 + (int)($ms >>> 32 ^ $ms);
            long $limit = this.getLimit();
            result = result * 59 + (int)($limit >>> 32 ^ $limit);
            return result;
        }

        public String toString() {
            return "Backoff.Constant(ms=" + this.getMs() + ", limit=" + this.getLimit() + ")";
        }
    }

    public static interface Policy {
        public static final Policy NONE = () -> Stream.empty();

        public Stream<Long> toBackoffs();
    }
}

