/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.bookkeeper.common.util;

import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;

public class ReflectionUtils {
    private static final Map<Class<?>, Constructor<?>> constructorCache = new ConcurrentHashMap();

    public static <T> Class<? extends T> forName(String className, Class<T> xface) {
        Class<?> theCls;
        try {
            theCls = Class.forName(className);
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException(cnfe);
        }
        if (!xface.isAssignableFrom(theCls)) {
            throw new RuntimeException(className + " not " + xface.getName());
        }
        return theCls.asSubclass(xface);
    }

    public static Class<?> getClass(Configuration conf, String name, Class<?> defaultCls, ClassLoader classLoader) throws ConfigurationException {
        String valueStr = conf.getString(name);
        if (null == valueStr) {
            return defaultCls;
        }
        try {
            return Class.forName(valueStr, true, classLoader);
        }
        catch (ClassNotFoundException cnfe) {
            throw new ConfigurationException((Throwable)cnfe);
        }
    }

    public static <T> Class<? extends T> getClass(Configuration conf, String name, Class<? extends T> defaultValue, Class<T> xface, ClassLoader classLoader) throws ConfigurationException {
        try {
            Class<?> theCls = ReflectionUtils.getClass(conf, name, defaultValue, classLoader);
            if (null != theCls && !xface.isAssignableFrom(theCls)) {
                throw new ConfigurationException(theCls + " not " + xface.getName());
            }
            if (null != theCls) {
                return theCls.asSubclass(xface);
            }
            return null;
        }
        catch (Exception e) {
            throw new ConfigurationException((Throwable)e);
        }
    }

    public static <T> T newInstance(Class<T> theCls) {
        Object result;
        try {
            Constructor<Object> meth = constructorCache.get(theCls);
            if (null == meth) {
                meth = theCls.getDeclaredConstructor(new Class[0]);
                meth.setAccessible(true);
                constructorCache.put(theCls, meth);
            }
            result = meth.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return (T)result;
    }

    public static <T> T newInstance(String clsName, Class<T> xface) {
        Class<?> theCls;
        try {
            theCls = Class.forName(clsName);
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException(cnfe);
        }
        if (!xface.isAssignableFrom(theCls)) {
            throw new RuntimeException(clsName + " not " + xface.getName());
        }
        return ReflectionUtils.newInstance(theCls.asSubclass(xface));
    }
}

