/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.bookkeeper.common.util;

import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FunctionalInterface
public interface SafeRunnable
extends Runnable {
    public static final Logger LOGGER = LoggerFactory.getLogger(SafeRunnable.class);

    @Override
    default public void run() {
        try {
            this.safeRun();
        }
        catch (Throwable t) {
            LOGGER.error("Unexpected throwable caught ", t);
        }
    }

    public void safeRun();

    public static SafeRunnable safeRun(final Runnable runnable) {
        return new SafeRunnable(){

            @Override
            public void safeRun() {
                runnable.run();
            }
        };
    }

    public static SafeRunnable safeRun(Runnable runnable, Consumer<Throwable> exceptionHandler) {
        return () -> {
            try {
                runnable.run();
            }
            catch (Throwable t) {
                exceptionHandler.accept(t);
                throw t;
            }
        };
    }
}

