/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.bookkeeper.common.util;

import dlshade.com.google.common.base.Preconditions;
import dlshade.org.apache.bookkeeper.common.util.ExecutorUtils;
import dlshade.org.apache.bookkeeper.common.util.LogExceptionRunnable;
import dlshade.org.apache.bookkeeper.common.util.ReferenceCounted;
import java.util.IdentityHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public class SharedResourceManager {
    static final long DESTROY_DELAY_SECONDS = 1L;
    private static final SharedResourceManager SHARED = SharedResourceManager.create();
    private final IdentityHashMap<Resource<?>, Instance> instances = new IdentityHashMap();
    private final Supplier<ScheduledExecutorService> destroyerFactory;
    private ScheduledExecutorService destroyer;

    public static SharedResourceManager shared() {
        return SHARED;
    }

    public static SharedResourceManager create() {
        return SharedResourceManager.create(() -> Executors.newSingleThreadScheduledExecutor(ExecutorUtils.getThreadFactory("bookkeeper-shared-destroyer-%d", true)));
    }

    public static SharedResourceManager create(Supplier<ScheduledExecutorService> destroyerFactory) {
        return new SharedResourceManager(destroyerFactory);
    }

    private SharedResourceManager(Supplier<ScheduledExecutorService> destroyerFactory) {
        this.destroyerFactory = destroyerFactory;
    }

    public synchronized <T> T get(Resource<T> resource) {
        Instance instance = this.instances.get(resource);
        if (null == instance) {
            instance = new Instance(resource.create());
            this.instances.put(resource, instance);
        }
        instance.cancelDestroyTask();
        instance.retain();
        return (T)instance.instance;
    }

    public synchronized <T> void release(Resource<T> resource, T instance) {
        Instance cached = this.instances.get(resource);
        Preconditions.checkArgument(null != cached, "No cached instance found for %s", resource);
        Preconditions.checkArgument(instance == cached.instance, "Release the wrong instance for %s", resource);
        Preconditions.checkState(cached.refCount > 0, "Refcount has already reached zero for %s", resource);
        cached.release();
        if (0 == cached.refCount) {
            Preconditions.checkState(null == cached.destroyTask, "Destroy task already scheduled for %s", resource);
            if (null == this.destroyer) {
                this.destroyer = this.destroyerFactory.get();
            }
            cached.destroyTask = this.destroyer.schedule(new LogExceptionRunnable(() -> {
                SharedResourceManager sharedResourceManager = this;
                synchronized (sharedResourceManager) {
                    if (cached.refCount == 0) {
                        resource.close(instance);
                        this.instances.remove(resource);
                        if (this.instances.isEmpty()) {
                            this.destroyer.shutdown();
                            this.destroyer = null;
                        }
                    }
                }
            }), 1L, TimeUnit.SECONDS);
        }
    }

    private static class Instance
    implements ReferenceCounted {
        private final Object instance;
        private int refCount;
        ScheduledFuture<?> destroyTask;

        Instance(Object instance) {
            this.instance = instance;
        }

        @Override
        public void retain() {
            ++this.refCount;
        }

        @Override
        public void release() {
            --this.refCount;
        }

        void cancelDestroyTask() {
            if (null != this.destroyTask) {
                this.destroyTask.cancel(false);
                this.destroyTask = null;
            }
        }
    }

    public static interface Resource<T> {
        public T create();

        public void close(T var1);
    }
}

