/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.bookkeeper.common.util;

import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleThreadSafeScheduledExecutorService
extends ScheduledThreadPoolExecutor
implements ScheduledExecutorService {
    private static final Logger log = LoggerFactory.getLogger(SingleThreadSafeScheduledExecutorService.class);

    public SingleThreadSafeScheduledExecutorService(ThreadFactory threadFactory) {
        super(1, threadFactory);
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return super.schedule(new SafeRunnable(command), delay, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return super.scheduleAtFixedRate(new SafeRunnable(command), initialDelay, period, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return super.scheduleWithFixedDelay(new SafeRunnable(command), initialDelay, delay, unit);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return super.submit(new SafeRunnable(task));
    }

    private static final class SafeRunnable
    implements Runnable {
        private final Runnable task;

        SafeRunnable(Runnable task) {
            this.task = task;
        }

        @Override
        public void run() {
            try {
                this.task.run();
            }
            catch (Throwable t) {
                log.warn("Unexpected throwable from task {}: {}", new Object[]{this.task.getClass(), t.getMessage(), t});
            }
        }
    }
}

