/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.bookkeeper.meta;

import dlshade.org.apache.bookkeeper.meta.HierarchicalLedgerManager;
import dlshade.org.apache.bookkeeper.meta.LedgerIdGenerator;
import dlshade.org.apache.bookkeeper.meta.LedgerManager;
import dlshade.org.apache.bookkeeper.meta.LegacyHierarchicalLedgerManagerFactory;
import dlshade.org.apache.bookkeeper.meta.LongZkLedgerIdGenerator;
import dlshade.org.apache.bookkeeper.meta.ZkLedgerIdGenerator;
import dlshade.org.apache.bookkeeper.meta.zk.ZKMetadataDriverBase;
import dlshade.org.apache.bookkeeper.util.ZkUtils;
import dlshade.org.apache.zookeeper.data.ACL;
import java.util.List;

public class HierarchicalLedgerManagerFactory
extends LegacyHierarchicalLedgerManagerFactory {
    public static final String NAME = "hierarchical";

    @Override
    public LedgerIdGenerator newLedgerIdGenerator() {
        List<ACL> zkAcls = ZkUtils.getACLs(this.conf);
        String zkLedgersRootPath = ZKMetadataDriverBase.resolveZkLedgersRootPath(this.conf);
        ZkLedgerIdGenerator subIdGenerator = new ZkLedgerIdGenerator(this.zk, zkLedgersRootPath, "idgen", zkAcls);
        return new LongZkLedgerIdGenerator(this.zk, zkLedgersRootPath, "idgen-long", subIdGenerator, zkAcls);
    }

    @Override
    public LedgerManager newLedgerManager() {
        return new HierarchicalLedgerManager(this.conf, this.zk);
    }
}

