/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.bookkeeper.proto;

import dlshade.com.google.common.base.Preconditions;
import dlshade.org.apache.bookkeeper.conf.ClientConfiguration;
import dlshade.org.apache.bookkeeper.net.BookieId;
import dlshade.org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import dlshade.org.apache.bookkeeper.proto.PerChannelBookieClient;
import dlshade.org.apache.bookkeeper.proto.PerChannelBookieClientFactory;
import dlshade.org.apache.bookkeeper.proto.PerChannelBookieClientPool;
import dlshade.org.apache.bookkeeper.tls.SecurityException;
import dlshade.org.apache.bookkeeper.tls.SecurityHandlerFactory;
import dlshade.org.apache.bookkeeper.tls.SecurityProviderFactoryFactory;
import dlshade.org.apache.bookkeeper.util.MathUtils;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultPerChannelBookieClientPool
implements PerChannelBookieClientPool,
BookkeeperInternalCallbacks.GenericCallback<PerChannelBookieClient> {
    static final Logger LOG = LoggerFactory.getLogger(DefaultPerChannelBookieClientPool.class);
    final PerChannelBookieClientFactory factory;
    final BookieId address;
    final PerChannelBookieClient[] clients;
    final PerChannelBookieClient[] clientsV3Enforced;
    final ClientConfiguration conf;
    SecurityHandlerFactory shFactory;
    final AtomicInteger counter = new AtomicInteger(0);
    final AtomicLong errorCounter = new AtomicLong(0L);

    DefaultPerChannelBookieClientPool(ClientConfiguration conf, PerChannelBookieClientFactory factory, BookieId address, int coreSize) throws SecurityException {
        int i;
        Preconditions.checkArgument(coreSize > 0);
        this.factory = factory;
        this.address = address;
        this.conf = conf;
        this.shFactory = SecurityProviderFactoryFactory.getSecurityProviderFactory(conf.getTLSProviderFactoryClass());
        this.clients = new PerChannelBookieClient[coreSize];
        for (i = 0; i < coreSize; ++i) {
            this.clients[i] = factory.create(address, this, this.shFactory, false);
        }
        if (conf.getUseV2WireProtocol()) {
            this.clientsV3Enforced = new PerChannelBookieClient[coreSize];
            for (i = 0; i < coreSize; ++i) {
                this.clientsV3Enforced[i] = factory.create(address, this, this.shFactory, true);
            }
        } else {
            this.clientsV3Enforced = this.clients;
        }
    }

    @Override
    public void operationComplete(int rc, PerChannelBookieClient pcbc) {
    }

    @Override
    public void initialize() {
        for (PerChannelBookieClient pcbc : this.clients) {
            pcbc.connectIfNeededAndDoOp(this);
        }
    }

    private PerChannelBookieClient getClient(long key) {
        return this.getClient(key, false);
    }

    private PerChannelBookieClient getClient(long key, PerChannelBookieClient[] pcbc) {
        if (1 == pcbc.length) {
            return pcbc[0];
        }
        int idx = MathUtils.signSafeMod(key, pcbc.length);
        return pcbc[idx];
    }

    private PerChannelBookieClient getClient(long key, boolean forceUseV3) {
        if (forceUseV3) {
            return this.getClient(key, this.clientsV3Enforced);
        }
        return this.getClient(key, this.clients);
    }

    @Override
    public void obtain(BookkeeperInternalCallbacks.GenericCallback<PerChannelBookieClient> callback, long key) {
        this.obtain(callback, key, false);
    }

    @Override
    public void obtain(BookkeeperInternalCallbacks.GenericCallback<PerChannelBookieClient> callback, long key, boolean forceUseV3) {
        this.getClient(key, forceUseV3).connectIfNeededAndDoOp(callback);
    }

    @Override
    public boolean isWritable(long key) {
        return this.getClient(key).isWritable();
    }

    @Override
    public void checkTimeoutOnPendingOperations() {
        for (int i = 0; i < this.clients.length; ++i) {
            this.clients[i].checkTimeoutOnPendingOperations();
            if (this.clients == this.clientsV3Enforced) continue;
            this.clientsV3Enforced[i].checkTimeoutOnPendingOperations();
        }
    }

    @Override
    public void recordError() {
        this.errorCounter.incrementAndGet();
    }

    @Override
    public void disconnect(boolean wait) {
        for (int i = 0; i < this.clients.length; ++i) {
            this.clients[i].disconnect();
            if (this.clients == this.clientsV3Enforced) continue;
            this.clientsV3Enforced[i].disconnect();
        }
    }

    @Override
    public void close(boolean wait) {
        for (int i = 0; i < this.clients.length; ++i) {
            this.clients[i].close(wait);
            if (this.clients == this.clientsV3Enforced) continue;
            this.clientsV3Enforced[i].close(wait);
        }
    }

    @Override
    public long getNumPendingCompletionRequests() {
        long numPending = 0L;
        for (PerChannelBookieClient pcbc : this.clients) {
            numPending += pcbc.getNumPendingCompletionRequests();
        }
        if (this.clients != this.clientsV3Enforced) {
            for (PerChannelBookieClient pcbc : this.clientsV3Enforced) {
                numPending += pcbc.getNumPendingCompletionRequests();
            }
        }
        return numPending;
    }
}

