/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.bookkeeper.proto;

import dlshade.com.google.common.base.Preconditions;
import dlshade.org.apache.bookkeeper.proto.BookieRequestHandler;
import dlshade.org.apache.bookkeeper.proto.BookieRequestProcessor;
import dlshade.org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import dlshade.org.apache.bookkeeper.proto.BookkeeperProtocol;
import dlshade.org.apache.bookkeeper.proto.PacketProcessorBaseV3;
import dlshade.org.apache.bookkeeper.proto.RequestUtils;
import dlshade.org.apache.bookkeeper.util.MathUtils;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ForceLedgerProcessorV3
extends PacketProcessorBaseV3
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(ForceLedgerProcessorV3.class);

    public ForceLedgerProcessorV3(BookkeeperProtocol.Request request, BookieRequestHandler requestHandler, BookieRequestProcessor requestProcessor) {
        super(request, requestHandler, requestProcessor);
    }

    private BookkeeperProtocol.ForceLedgerResponse getForceLedgerResponse() {
        long startTimeNanos = MathUtils.nowInNano();
        BookkeeperProtocol.ForceLedgerRequest forceLedgerRequest = this.request.getForceLedgerRequest();
        long ledgerId = forceLedgerRequest.getLedgerId();
        BookkeeperProtocol.ForceLedgerResponse.Builder forceLedgerResponse = BookkeeperProtocol.ForceLedgerResponse.newBuilder().setLedgerId(ledgerId);
        if (!this.isVersionCompatible()) {
            forceLedgerResponse.setStatus(BookkeeperProtocol.StatusCode.EBADVERSION);
            return forceLedgerResponse.build();
        }
        BookkeeperInternalCallbacks.WriteCallback wcb = (rc, ledgerId1, entryId, addr, ctx) -> {
            BookkeeperProtocol.StatusCode status;
            Preconditions.checkArgument(entryId == -16384L, "entryId must be METAENTRY_ID_FORCE_LEDGER but was {}", entryId);
            Preconditions.checkArgument(ledgerId1 == ledgerId, "ledgerId must be {} but was {}", ledgerId, ledgerId1);
            if (0 == rc) {
                this.requestProcessor.getRequestStats().getForceLedgerStats().registerSuccessfulEvent(MathUtils.elapsedNanos(startTimeNanos), TimeUnit.NANOSECONDS);
            } else {
                this.requestProcessor.getRequestStats().getForceLedgerStats().registerFailedEvent(MathUtils.elapsedNanos(startTimeNanos), TimeUnit.NANOSECONDS);
            }
            switch (rc) {
                case 0: {
                    status = BookkeeperProtocol.StatusCode.EOK;
                    break;
                }
                case 101: {
                    status = BookkeeperProtocol.StatusCode.EIO;
                    break;
                }
                default: {
                    status = BookkeeperProtocol.StatusCode.EUA;
                }
            }
            forceLedgerResponse.setStatus(status);
            BookkeeperProtocol.Response.Builder response = BookkeeperProtocol.Response.newBuilder().setHeader(this.getHeader()).setStatus(forceLedgerResponse.getStatus()).setForceLedgerResponse(forceLedgerResponse);
            BookkeeperProtocol.Response resp = response.build();
            this.sendResponse(status, resp, this.requestProcessor.getRequestStats().getForceLedgerRequestStats());
        };
        BookkeeperProtocol.StatusCode status = null;
        try {
            this.requestProcessor.getBookie().forceLedger(ledgerId, wcb, (Object)this.requestHandler);
            status = BookkeeperProtocol.StatusCode.EOK;
        }
        catch (Throwable t) {
            logger.error("Unexpected exception while forcing ledger {} : ", (Object)ledgerId, (Object)t);
            status = BookkeeperProtocol.StatusCode.EBADREQ;
        }
        if (!status.equals(BookkeeperProtocol.StatusCode.EOK)) {
            forceLedgerResponse.setStatus(status);
            return forceLedgerResponse.build();
        }
        return null;
    }

    @Override
    public void run() {
        BookkeeperProtocol.ForceLedgerResponse forceLedgerResponse = this.getForceLedgerResponse();
        if (null != forceLedgerResponse) {
            BookkeeperProtocol.Response.Builder response = BookkeeperProtocol.Response.newBuilder().setHeader(this.getHeader()).setStatus(forceLedgerResponse.getStatus()).setForceLedgerResponse(forceLedgerResponse);
            BookkeeperProtocol.Response resp = response.build();
            this.sendResponse(forceLedgerResponse.getStatus(), resp, this.requestProcessor.getRequestStats().getForceLedgerRequestStats());
        }
    }

    @Override
    public String toString() {
        return RequestUtils.toSafeString(this.request);
    }
}

