/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.bookkeeper.proto.checksum;

import dlshade.com.scurrilous.circe.checksum.Crc32cIntChecksum;
import dlshade.org.apache.bookkeeper.proto.checksum.DigestManager;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CRC32CDigestManager
extends DigestManager {
    private static final Logger log = LoggerFactory.getLogger(CRC32CDigestManager.class);

    public CRC32CDigestManager(long ledgerId, boolean useV2Protocol, ByteBufAllocator allocator) {
        super(ledgerId, useV2Protocol, allocator);
    }

    @Override
    int getMacCodeLength() {
        return 4;
    }

    @Override
    boolean isInt32Digest() {
        return true;
    }

    @Override
    void populateValueAndReset(int digest, ByteBuf buf) {
        buf.writeInt(digest);
    }

    @Override
    int internalUpdate(int digest, ByteBuf data, int offset, int len) {
        return Crc32cIntChecksum.resumeChecksum(digest, data, offset, len);
    }

    @Override
    int internalUpdate(int digest, byte[] buffer, int offset, int len) {
        return Crc32cIntChecksum.resumeChecksum(digest, buffer, offset, len);
    }

    @Override
    boolean acceptsMemoryAddressBuffer() {
        return Crc32cIntChecksum.acceptsMemoryAddressBuffer();
    }
}

