/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.bookkeeper.proto.checksum;

import dlshade.org.apache.bookkeeper.client.BKException;
import dlshade.org.apache.bookkeeper.proto.BookieProtocol;
import dlshade.org.apache.bookkeeper.proto.DataFormats;
import dlshade.org.apache.bookkeeper.proto.checksum.CRC32CDigestManager;
import dlshade.org.apache.bookkeeper.proto.checksum.CRC32DigestManager;
import dlshade.org.apache.bookkeeper.proto.checksum.DummyDigestManager;
import dlshade.org.apache.bookkeeper.proto.checksum.MacDigestManager;
import dlshade.org.apache.bookkeeper.util.ByteBufList;
import dlshade.org.apache.bookkeeper.util.ByteBufVisitor;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.util.ReferenceCounted;
import io.netty.util.concurrent.FastThreadLocal;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DigestManager {
    private static final Logger logger = LoggerFactory.getLogger(DigestManager.class);
    public static final int METADATA_LENGTH = 32;
    public static final int LAC_METADATA_LENGTH = 16;
    final long ledgerId;
    final boolean useV2Protocol;
    private final ByteBufAllocator allocator;
    private final DigestUpdaterByteBufVisitorCallback byteBufVisitorCallback;
    final int macCodeLength;
    private static final FastThreadLocal<ByteBuf> DIGEST_BUFFER = new FastThreadLocal<ByteBuf>(){

        protected ByteBuf initialValue() throws Exception {
            return PooledByteBufAllocator.DEFAULT.directBuffer(1024);
        }

        protected void onRemoval(ByteBuf value) throws Exception {
            value.release();
        }
    };

    abstract int getMacCodeLength();

    abstract int internalUpdate(int var1, ByteBuf var2, int var3, int var4);

    abstract int internalUpdate(int var1, byte[] var2, int var3, int var4);

    final int update(int digest, ByteBuf buffer, int offset, int len) {
        if (buffer.hasMemoryAddress() && this.acceptsMemoryAddressBuffer()) {
            return this.internalUpdate(digest, buffer, offset, len);
        }
        if (buffer.hasArray()) {
            return this.internalUpdate(digest, buffer.array(), buffer.arrayOffset() + offset, len);
        }
        UpdateContext updateContext = new UpdateContext(digest);
        ByteBufVisitor.visitBuffers(buffer, offset, len, this.byteBufVisitorCallback, updateContext);
        return updateContext.digest;
    }

    abstract void populateValueAndReset(int var1, ByteBuf var2);

    abstract boolean isInt32Digest();

    public DigestManager(long ledgerId, boolean useV2Protocol, ByteBufAllocator allocator) {
        this.ledgerId = ledgerId;
        this.useV2Protocol = useV2Protocol;
        this.macCodeLength = this.getMacCodeLength();
        this.allocator = allocator;
        this.byteBufVisitorCallback = new DigestUpdaterByteBufVisitorCallback();
    }

    public static DigestManager instantiate(long ledgerId, byte[] passwd, DataFormats.LedgerMetadataFormat.DigestType digestType, ByteBufAllocator allocator, boolean useV2Protocol) throws GeneralSecurityException {
        switch (digestType) {
            case HMAC: {
                return new MacDigestManager(ledgerId, passwd, useV2Protocol, allocator);
            }
            case CRC32: {
                return new CRC32DigestManager(ledgerId, useV2Protocol, allocator);
            }
            case CRC32C: {
                return new CRC32CDigestManager(ledgerId, useV2Protocol, allocator);
            }
            case DUMMY: {
                return new DummyDigestManager(ledgerId, useV2Protocol, allocator);
            }
        }
        throw new GeneralSecurityException("Unknown checksum type: " + digestType);
    }

    public static byte[] generateMasterKey(byte[] password) throws NoSuchAlgorithmException {
        return password.length > 0 ? MacDigestManager.genDigest("ledger", password) : MacDigestManager.EMPTY_LEDGER_KEY;
    }

    public ReferenceCounted computeDigestAndPackageForSending(long entryId, long lastAddConfirmed, long length, ByteBuf data, byte[] masterKey, int flags) {
        if (this.useV2Protocol) {
            return this.computeDigestAndPackageForSendingV2(entryId, lastAddConfirmed, length, data, masterKey, flags);
        }
        return this.computeDigestAndPackageForSendingV3(entryId, lastAddConfirmed, length, data);
    }

    private ReferenceCounted computeDigestAndPackageForSendingV2(long entryId, long lastAddConfirmed, long length, ByteBuf data, byte[] masterKey, int flags) {
        boolean isSmallEntry = data.readableBytes() < 16384;
        int headersSize = 56 + this.macCodeLength;
        int payloadSize = data.readableBytes();
        int bufferSize = 4 + headersSize + (isSmallEntry ? payloadSize : 0);
        ByteBuf buf = this.allocator.buffer(bufferSize, bufferSize);
        buf.writeInt(headersSize + payloadSize);
        buf.writeInt(BookieProtocol.PacketHeader.toInt((byte)2, (byte)1, (short)flags));
        buf.writeBytes(masterKey, 0, 20);
        buf.readerIndex(buf.writerIndex());
        buf.writeLong(this.ledgerId);
        buf.writeLong(entryId);
        buf.writeLong(lastAddConfirmed);
        buf.writeLong(length);
        int digest = this.update(0, buf, buf.readerIndex(), buf.readableBytes());
        digest = this.update(digest, data, data.readerIndex(), data.readableBytes());
        this.populateValueAndReset(digest, buf);
        buf.readerIndex(0);
        if (isSmallEntry) {
            buf.writeBytes(data, data.readerIndex(), data.readableBytes());
            data.release();
            return buf;
        }
        return ByteBufList.get(buf, data);
    }

    private ByteBufList computeDigestAndPackageForSendingV3(long entryId, long lastAddConfirmed, long length, ByteBuf data) {
        ByteBuf headersBuffer = Unpooled.buffer((int)(32 + this.macCodeLength));
        headersBuffer.writeLong(this.ledgerId);
        headersBuffer.writeLong(entryId);
        headersBuffer.writeLong(lastAddConfirmed);
        headersBuffer.writeLong(length);
        int digest = this.update(0, headersBuffer, 0, 32);
        digest = this.update(digest, data, data.readerIndex(), data.readableBytes());
        this.populateValueAndReset(digest, headersBuffer);
        return ByteBufList.get(headersBuffer, data);
    }

    public ByteBufList computeDigestAndPackageForSendingLac(long lac) {
        ByteBuf headersBuffer = this.useV2Protocol ? this.allocator.buffer(16 + this.macCodeLength) : Unpooled.buffer((int)(16 + this.macCodeLength));
        headersBuffer.writeLong(this.ledgerId);
        headersBuffer.writeLong(lac);
        int digest = this.update(0, headersBuffer, 0, 16);
        this.populateValueAndReset(digest, headersBuffer);
        return ByteBufList.get(headersBuffer);
    }

    private void verifyDigest(ByteBuf dataReceived) throws BKException.BKDigestMatchException {
        this.verifyDigest(-1L, dataReceived, true);
    }

    private void verifyDigest(long entryId, ByteBuf dataReceived) throws BKException.BKDigestMatchException {
        this.verifyDigest(entryId, dataReceived, false);
    }

    private void verifyDigest(long entryId, ByteBuf dataReceived, boolean skipEntryIdCheck) throws BKException.BKDigestMatchException {
        if (32 + this.macCodeLength > dataReceived.readableBytes()) {
            logger.error("Data received is smaller than the minimum for this digest type.  Either the packet it corrupt, or the wrong digest is configured.  Digest type: {}, Packet Length: {}", (Object)this.getClass().getName(), (Object)dataReceived.readableBytes());
            throw new BKException.BKDigestMatchException();
        }
        int digest = this.update(0, dataReceived, 0, 32);
        int offset = 32 + this.macCodeLength;
        digest = this.update(digest, dataReceived, offset, dataReceived.readableBytes() - offset);
        if (this.isInt32Digest()) {
            int receivedDigest = dataReceived.getInt(32);
            if (receivedDigest != digest) {
                logger.error("Digest mismatch for ledger-id: " + this.ledgerId + ", entry-id: " + entryId);
                throw new BKException.BKDigestMatchException();
            }
        } else {
            ByteBuf digestBuf = (ByteBuf)DIGEST_BUFFER.get();
            digestBuf.clear();
            this.populateValueAndReset(digest, digestBuf);
            if (!ByteBufUtil.equals((ByteBuf)digestBuf, (int)0, (ByteBuf)dataReceived, (int)32, (int)this.macCodeLength)) {
                logger.error("Mac mismatch for ledger-id: " + this.ledgerId + ", entry-id: " + entryId);
                throw new BKException.BKDigestMatchException();
            }
        }
        long actualLedgerId = dataReceived.readLong();
        long actualEntryId = dataReceived.readLong();
        if (actualLedgerId != this.ledgerId) {
            logger.error("Ledger-id mismatch in authenticated message, expected: " + this.ledgerId + " , actual: " + actualLedgerId);
            throw new BKException.BKDigestMatchException();
        }
        if (!skipEntryIdCheck && actualEntryId != entryId) {
            logger.error("Entry-id mismatch in authenticated message, expected: " + entryId + " , actual: " + actualEntryId);
            throw new BKException.BKDigestMatchException();
        }
    }

    public long verifyDigestAndReturnLac(ByteBuf dataReceived) throws BKException.BKDigestMatchException {
        if (16 + this.macCodeLength > dataReceived.readableBytes()) {
            logger.error("Data received is smaller than the minimum for this digest type. Either the packet it corrupt, or the wrong digest is configured.  Digest type: {}, Packet Length: {}", (Object)this.getClass().getName(), (Object)dataReceived.readableBytes());
            throw new BKException.BKDigestMatchException();
        }
        int digest = this.update(0, dataReceived, 0, 16);
        if (this.isInt32Digest()) {
            int receivedDigest = dataReceived.getInt(16);
            if (receivedDigest != digest) {
                logger.error("Digest mismatch for ledger-id LAC: " + this.ledgerId);
                throw new BKException.BKDigestMatchException();
            }
        } else {
            ByteBuf digestBuf = (ByteBuf)DIGEST_BUFFER.get();
            digestBuf.clear();
            this.populateValueAndReset(digest, digestBuf);
            if (!ByteBufUtil.equals((ByteBuf)digestBuf, (int)0, (ByteBuf)dataReceived, (int)16, (int)this.macCodeLength)) {
                logger.error("Mac mismatch for ledger-id LAC: " + this.ledgerId);
                throw new BKException.BKDigestMatchException();
            }
        }
        long actualLedgerId = dataReceived.readLong();
        long lac = dataReceived.readLong();
        if (actualLedgerId != this.ledgerId) {
            logger.error("Ledger-id mismatch in authenticated message, expected: " + this.ledgerId + " , actual: " + actualLedgerId);
            throw new BKException.BKDigestMatchException();
        }
        return lac;
    }

    public ByteBuf verifyDigestAndReturnData(long entryId, ByteBuf dataReceived) throws BKException.BKDigestMatchException {
        this.verifyDigest(entryId, dataReceived);
        dataReceived.readerIndex(32 + this.macCodeLength);
        return dataReceived;
    }

    public RecoveryData verifyDigestAndReturnLastConfirmed(ByteBuf dataReceived) throws BKException.BKDigestMatchException {
        this.verifyDigest(dataReceived);
        dataReceived.readerIndex(8);
        dataReceived.readLong();
        long lastAddConfirmed = dataReceived.readLong();
        long length = dataReceived.readLong();
        return new RecoveryData(lastAddConfirmed, length);
    }

    abstract boolean acceptsMemoryAddressBuffer();

    private class DigestUpdaterByteBufVisitorCallback
    implements ByteBufVisitor.ByteBufVisitorCallback<UpdateContext> {
        private DigestUpdaterByteBufVisitorCallback() {
        }

        @Override
        public void visitBuffer(UpdateContext context, ByteBuf visitBuffer, int visitIndex, int visitLength) {
            context.digest = DigestManager.this.internalUpdate(context.digest, visitBuffer, visitIndex, visitLength);
        }

        @Override
        public void visitArray(UpdateContext context, byte[] visitArray, int visitIndex, int visitLength) {
            context.digest = DigestManager.this.internalUpdate(context.digest, visitArray, visitIndex, visitLength);
        }

        @Override
        public boolean acceptsMemoryAddress(UpdateContext context) {
            return DigestManager.this.acceptsMemoryAddressBuffer();
        }
    }

    private static class UpdateContext {
        int digest;

        UpdateContext(int digest) {
            this.digest = digest;
        }
    }

    public static final class RecoveryData {
        final long lastAddConfirmed;
        final long length;

        public RecoveryData(long lastAddConfirmed, long length) {
            this.lastAddConfirmed = lastAddConfirmed;
            this.length = length;
        }

        public long getLastAddConfirmed() {
            return this.lastAddConfirmed;
        }

        public long getLength() {
            return this.length;
        }
    }
}

