/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.bookkeeper.server;

import dlshade.com.google.common.base.Preconditions;
import dlshade.com.google.common.base.Ticker;
import dlshade.com.google.common.util.concurrent.ThreadFactoryBuilder;
import dlshade.org.apache.bookkeeper.bookie.BookieImpl;
import dlshade.org.apache.bookkeeper.bookie.BookieResources;
import dlshade.org.apache.bookkeeper.bookie.LedgerDirsManager;
import dlshade.org.apache.bookkeeper.bookie.LedgerStorage;
import dlshade.org.apache.bookkeeper.bookie.LegacyCookieValidation;
import dlshade.org.apache.bookkeeper.bookie.ReadOnlyBookie;
import dlshade.org.apache.bookkeeper.bookie.UncleanShutdownDetection;
import dlshade.org.apache.bookkeeper.bookie.UncleanShutdownDetectionImpl;
import dlshade.org.apache.bookkeeper.bookie.datainteg.DataIntegrityCheckImpl;
import dlshade.org.apache.bookkeeper.bookie.datainteg.DataIntegrityCookieValidation;
import dlshade.org.apache.bookkeeper.bookie.datainteg.DataIntegrityService;
import dlshade.org.apache.bookkeeper.bookie.datainteg.EntryCopierImpl;
import dlshade.org.apache.bookkeeper.client.BookKeeper;
import dlshade.org.apache.bookkeeper.client.BookKeeperAdmin;
import dlshade.org.apache.bookkeeper.common.allocator.ByteBufAllocatorWithOomHandler;
import dlshade.org.apache.bookkeeper.common.component.AutoCloseableLifecycleComponent;
import dlshade.org.apache.bookkeeper.common.component.ComponentInfoPublisher;
import dlshade.org.apache.bookkeeper.common.component.LifecycleComponentStack;
import dlshade.org.apache.bookkeeper.common.component.RxSchedulerLifecycleComponent;
import dlshade.org.apache.bookkeeper.conf.ClientConfiguration;
import dlshade.org.apache.bookkeeper.discover.BookieServiceInfo;
import dlshade.org.apache.bookkeeper.discover.RegistrationManager;
import dlshade.org.apache.bookkeeper.meta.LedgerManager;
import dlshade.org.apache.bookkeeper.meta.LedgerManagerFactory;
import dlshade.org.apache.bookkeeper.meta.MetadataBookieDriver;
import dlshade.org.apache.bookkeeper.net.BookieId;
import dlshade.org.apache.bookkeeper.server.Main;
import dlshade.org.apache.bookkeeper.server.component.ServerLifecycleComponent;
import dlshade.org.apache.bookkeeper.server.conf.BookieConfiguration;
import dlshade.org.apache.bookkeeper.server.http.BKHttpServiceProvider;
import dlshade.org.apache.bookkeeper.server.service.AutoRecoveryService;
import dlshade.org.apache.bookkeeper.server.service.BookieService;
import dlshade.org.apache.bookkeeper.server.service.HttpService;
import dlshade.org.apache.bookkeeper.server.service.ScrubberService;
import dlshade.org.apache.bookkeeper.server.service.StatsProviderService;
import dlshade.org.apache.bookkeeper.stats.StatsLogger;
import dlshade.org.apache.bookkeeper.stats.StatsProvider;
import dlshade.org.apache.bookkeeper.util.DiskChecker;
import dlshade.org.apache.commons.lang3.StringUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedServer {
    private final LifecycleComponentStack lifecycleComponentStack;
    private final StatsProvider statsProvider;
    private final RegistrationManager registrationManager;
    private final LedgerManagerFactory ledgerManagerFactory;
    private final DiskChecker diskChecker;
    private final LedgerDirsManager ledgerDirsManager;
    private final LedgerDirsManager indexDirsManager;
    private final BookieService bookieService;
    private final AutoRecoveryService autoRecoveryService;
    private final DataIntegrityService dataIntegrityService;
    private final HttpService httpService;

    private EmbeddedServer(LifecycleComponentStack lifecycleComponentStack, StatsProvider statsProvider, RegistrationManager registrationManager, LedgerManagerFactory ledgerManagerFactory, DiskChecker diskChecker, LedgerDirsManager ledgerDirsManager, LedgerDirsManager indexDirsManager, BookieService bookieService, AutoRecoveryService autoRecoveryService, DataIntegrityService dataIntegrityService, HttpService httpService) {
        this.lifecycleComponentStack = lifecycleComponentStack;
        this.statsProvider = statsProvider;
        this.registrationManager = registrationManager;
        this.ledgerManagerFactory = ledgerManagerFactory;
        this.diskChecker = diskChecker;
        this.ledgerDirsManager = ledgerDirsManager;
        this.indexDirsManager = indexDirsManager;
        this.bookieService = bookieService;
        this.autoRecoveryService = autoRecoveryService;
        this.dataIntegrityService = dataIntegrityService;
        this.httpService = httpService;
    }

    public LifecycleComponentStack getLifecycleComponentStack() {
        return this.lifecycleComponentStack;
    }

    public StatsProvider getStatsProvider() {
        return this.statsProvider;
    }

    public RegistrationManager getRegistrationManager() {
        return this.registrationManager;
    }

    public LedgerManagerFactory getLedgerManagerFactory() {
        return this.ledgerManagerFactory;
    }

    public DiskChecker getDiskChecker() {
        return this.diskChecker;
    }

    public LedgerDirsManager getLedgerDirsManager() {
        return this.ledgerDirsManager;
    }

    public LedgerDirsManager getIndexDirsManager() {
        return this.indexDirsManager;
    }

    public BookieService getBookieService() {
        return this.bookieService;
    }

    public AutoRecoveryService getAutoRecoveryService() {
        return this.autoRecoveryService;
    }

    public DataIntegrityService getDataIntegrityService() {
        return this.dataIntegrityService;
    }

    public HttpService getHttpService() {
        return this.httpService;
    }

    public static final Builder builder(BookieConfiguration conf) {
        return new Builder(conf);
    }

    private static final class ByteBuffAllocatorWrapper
    implements ByteBufAllocatorWithOomHandler {
        private final ByteBufAllocator allocator;

        public ByteBuf buffer() {
            return this.allocator.buffer();
        }

        public ByteBuf buffer(int i) {
            return this.allocator.buffer(i);
        }

        public ByteBuf buffer(int i, int i1) {
            return this.allocator.buffer(i, i1);
        }

        public ByteBuf ioBuffer() {
            return this.allocator.ioBuffer();
        }

        public ByteBuf ioBuffer(int i) {
            return this.allocator.ioBuffer(i);
        }

        public ByteBuf ioBuffer(int i, int i1) {
            return this.allocator.ioBuffer(i, i1);
        }

        public ByteBuf heapBuffer() {
            return this.allocator.heapBuffer();
        }

        public ByteBuf heapBuffer(int i) {
            return this.allocator.heapBuffer(i);
        }

        public ByteBuf heapBuffer(int i, int i1) {
            return this.allocator.heapBuffer(i, i1);
        }

        public ByteBuf directBuffer() {
            return this.allocator.directBuffer();
        }

        public ByteBuf directBuffer(int i) {
            return this.allocator.directBuffer(i);
        }

        public ByteBuf directBuffer(int i, int i1) {
            return this.allocator.directBuffer(i, i1);
        }

        public CompositeByteBuf compositeBuffer() {
            return this.allocator.compositeBuffer();
        }

        public CompositeByteBuf compositeBuffer(int i) {
            return this.allocator.compositeBuffer(i);
        }

        public CompositeByteBuf compositeHeapBuffer() {
            return this.allocator.compositeHeapBuffer();
        }

        public CompositeByteBuf compositeHeapBuffer(int i) {
            return this.allocator.compositeHeapBuffer(i);
        }

        public CompositeByteBuf compositeDirectBuffer() {
            return this.allocator.compositeDirectBuffer();
        }

        public CompositeByteBuf compositeDirectBuffer(int i) {
            return this.allocator.compositeDirectBuffer(i);
        }

        public boolean isDirectBufferPooled() {
            return this.allocator.isDirectBufferPooled();
        }

        public int calculateNewCapacity(int i, int i1) {
            return this.allocator.calculateNewCapacity(i, i1);
        }

        public ByteBuffAllocatorWrapper(ByteBufAllocator allocator) {
            this.allocator = allocator;
        }

        @Override
        public void setOomHandler(Consumer<OutOfMemoryError> handler) {
        }
    }

    public static class Builder {
        private static final Logger log = LoggerFactory.getLogger(Builder.class);
        private BookieConfiguration conf;
        private StatsProvider statsProvider;
        private MetadataBookieDriver metadataDriver;
        private RegistrationManager registrationManager;
        private LedgerManagerFactory ledgerManagerFactory;
        private DiskChecker diskChecker;
        private LedgerDirsManager ledgerDirsManager;
        private LedgerDirsManager indexDirsManager;
        private ByteBufAllocator allocator;
        private UncleanShutdownDetection uncleanShutdownDetection;

        private Builder(BookieConfiguration conf) {
            Preconditions.checkNotNull(conf, "bookieConfiguration cannot be null");
            this.conf = conf;
        }

        public Builder statsProvider(StatsProvider statsProvider) {
            this.statsProvider = statsProvider;
            return this;
        }

        public Builder metadataDriver(MetadataBookieDriver metadataDriver) {
            this.metadataDriver = metadataDriver;
            return this;
        }

        public Builder registrationManager(RegistrationManager registrationManager) {
            this.registrationManager = registrationManager;
            return this;
        }

        public Builder ledgerManagerFactory(LedgerManagerFactory ledgerManagerFactory) {
            this.ledgerManagerFactory = ledgerManagerFactory;
            return this;
        }

        public Builder diskChecker(DiskChecker diskChecker) {
            this.diskChecker = diskChecker;
            return this;
        }

        public Builder ledgerDirsManager(LedgerDirsManager ledgerDirsManager) {
            this.ledgerDirsManager = ledgerDirsManager;
            return this;
        }

        public Builder indexDirsManager(LedgerDirsManager indexDirsManager) {
            this.indexDirsManager = indexDirsManager;
            return this;
        }

        public Builder allocator(ByteBufAllocator allocator) {
            this.allocator = allocator;
            return this;
        }

        public Builder uncleanShutdownDetection(UncleanShutdownDetection uncleanShutdownDetection) {
            this.uncleanShutdownDetection = uncleanShutdownDetection;
            return this;
        }

        public EmbeddedServer build() throws Exception {
            String[] extraComponents;
            ByteBufAllocatorWithOomHandler allocatorWithOomHandler;
            ComponentInfoPublisher componentInfoPublisher = new ComponentInfoPublisher();
            Supplier<BookieServiceInfo> bookieServiceInfoProvider = () -> Builder.buildBookieServiceInfo(componentInfoPublisher);
            LifecycleComponentStack.Builder serverBuilder = LifecycleComponentStack.newBuilder().withComponentInfoPublisher(componentInfoPublisher).withName("bookie-server");
            if (this.statsProvider == null) {
                StatsProviderService statsProviderService = new StatsProviderService(this.conf);
                this.statsProvider = statsProviderService.getStatsProvider();
                serverBuilder.addComponent(statsProviderService);
                log.info("Load lifecycle component : {}", (Object)statsProviderService.getName());
            }
            StatsLogger rootStatsLogger = this.statsProvider.getStatsLogger("");
            if (this.metadataDriver == null && (this.ledgerManagerFactory == null || this.registrationManager == null)) {
                this.metadataDriver = BookieResources.createMetadataDriver(this.conf.getServerConf(), rootStatsLogger);
                serverBuilder.addComponent(new AutoCloseableLifecycleComponent("metadataDriver", this.metadataDriver));
            }
            if (this.registrationManager == null) {
                this.registrationManager = this.metadataDriver.createRegistrationManager();
                serverBuilder.addComponent(new AutoCloseableLifecycleComponent("registrationManager", this.registrationManager));
            }
            if (this.ledgerManagerFactory == null) {
                this.ledgerManagerFactory = this.metadataDriver.getLedgerManagerFactory();
                serverBuilder.addComponent(new AutoCloseableLifecycleComponent("lmFactory", this.ledgerManagerFactory));
            }
            LedgerManager ledgerManager = this.ledgerManagerFactory.newLedgerManager();
            serverBuilder.addComponent(new AutoCloseableLifecycleComponent("ledgerManager", ledgerManager));
            StatsLogger bookieStats = rootStatsLogger.scope("bookie");
            if (this.diskChecker == null) {
                this.diskChecker = BookieResources.createDiskChecker(this.conf.getServerConf());
            }
            if (this.ledgerDirsManager == null) {
                this.ledgerDirsManager = BookieResources.createLedgerDirsManager(this.conf.getServerConf(), this.diskChecker, bookieStats.scope("ledger"));
            }
            if (this.indexDirsManager == null) {
                this.indexDirsManager = BookieResources.createIndexDirsManager(this.conf.getServerConf(), this.diskChecker, bookieStats.scope("index"), this.ledgerDirsManager);
            }
            if (this.allocator == null) {
                allocatorWithOomHandler = BookieResources.createAllocator(this.conf.getServerConf());
                this.allocator = allocatorWithOomHandler;
            } else {
                allocatorWithOomHandler = this.allocator instanceof ByteBufAllocatorWithOomHandler ? (ByteBufAllocatorWithOomHandler)this.allocator : new ByteBuffAllocatorWrapper(this.allocator);
            }
            if (this.uncleanShutdownDetection == null) {
                this.uncleanShutdownDetection = new UncleanShutdownDetectionImpl(this.ledgerDirsManager);
            }
            if (this.uncleanShutdownDetection.lastShutdownWasUnclean()) {
                log.info("Unclean shutdown detected. The bookie did not register a graceful shutdown prior to this boot.");
            }
            LedgerStorage storage = null;
            DataIntegrityCheckImpl integCheck = null;
            if (this.conf.getServerConf().isDataIntegrityCheckingEnabled()) {
                StatsLogger clientStats = bookieStats.scope("bookkeeper_client");
                ClientConfiguration clientConfiguration = new ClientConfiguration(this.conf.getServerConf());
                clientConfiguration.setClientRole("system");
                BookKeeper bkc = BookKeeper.forConfig(clientConfiguration).statsLogger(clientStats).build();
                serverBuilder.addComponent(new AutoCloseableLifecycleComponent("bkc", bkc));
                BookieId bookieId = BookieImpl.getBookieId(this.conf.getServerConf());
                ExecutorService rxExecutor = Executors.newFixedThreadPool(2, new ThreadFactoryBuilder().setNameFormat("rx-schedule-%d").setUncaughtExceptionHandler((t, ex) -> log.error("Uncaught exception on thread {}", (Object)t.getName(), (Object)ex)).build());
                Scheduler rxScheduler = Schedulers.from((Executor)rxExecutor);
                serverBuilder.addComponent(new RxSchedulerLifecycleComponent("rx-scheduler", this.conf, bookieStats, rxScheduler, rxExecutor));
                storage = BookieResources.createLedgerStorage(this.conf.getServerConf(), ledgerManager, this.ledgerDirsManager, this.indexDirsManager, bookieStats, this.allocator);
                EntryCopierImpl copier = new EntryCopierImpl(bookieId, bkc.getClientCtx().getBookieClient(), storage, Ticker.systemTicker());
                integCheck = new DataIntegrityCheckImpl(bookieId, ledgerManager, storage, copier, new BookKeeperAdmin(bkc, clientStats, clientConfiguration), rxScheduler);
                if (!this.conf.getServerConf().getJournalWriteData() && this.uncleanShutdownDetection.lastShutdownWasUnclean()) {
                    integCheck.runPreBootCheck("UNCLEAN_SHUTDOWN");
                }
                DataIntegrityCookieValidation cookieValidation = new DataIntegrityCookieValidation(this.conf.getServerConf(), this.registrationManager, integCheck);
                cookieValidation.checkCookies(Main.storageDirectoriesFromConf(this.conf.getServerConf()));
            } else {
                LegacyCookieValidation cookieValidation = new LegacyCookieValidation(this.conf.getServerConf(), this.registrationManager);
                cookieValidation.checkCookies(Main.storageDirectoriesFromConf(this.conf.getServerConf()));
                storage = BookieResources.createLedgerStorage(this.conf.getServerConf(), ledgerManager, this.ledgerDirsManager, this.indexDirsManager, bookieStats, this.allocator);
            }
            BookieImpl bookie = this.conf.getServerConf().isForceReadOnlyBookie() ? new ReadOnlyBookie(this.conf.getServerConf(), this.registrationManager, storage, this.diskChecker, this.ledgerDirsManager, this.indexDirsManager, bookieStats, this.allocator, bookieServiceInfoProvider) : new BookieImpl(this.conf.getServerConf(), this.registrationManager, storage, this.diskChecker, this.ledgerDirsManager, this.indexDirsManager, bookieStats, this.allocator, bookieServiceInfoProvider);
            BookieService bookieService = new BookieService(this.conf, bookie, rootStatsLogger, allocatorWithOomHandler, this.uncleanShutdownDetection);
            serverBuilder.addComponent(bookieService);
            log.info("Load lifecycle component : {}", (Object)bookieService.getName());
            if (this.conf.getServerConf().isLocalScrubEnabled()) {
                serverBuilder.addComponent(new ScrubberService(rootStatsLogger.scope("scrubber"), this.conf, bookieService.getServer().getBookie().getLedgerStorage()));
            }
            AutoRecoveryService autoRecoveryService = null;
            if (this.conf.getServerConf().isAutoRecoveryDaemonEnabled()) {
                autoRecoveryService = new AutoRecoveryService(this.conf, rootStatsLogger.scope("replication"));
                serverBuilder.addComponent(autoRecoveryService);
                log.info("Load lifecycle component : {}", (Object)autoRecoveryService.getName());
            }
            DataIntegrityService dataIntegrityService = null;
            if (this.conf.getServerConf().isDataIntegrityCheckingEnabled()) {
                Preconditions.checkNotNull(integCheck, "integCheck should have been initialized with the cookie validation");
                dataIntegrityService = new DataIntegrityService(this.conf, rootStatsLogger.scope("replication"), integCheck);
                serverBuilder.addComponent(dataIntegrityService);
                log.info("Load lifecycle component : {}", (Object)dataIntegrityService.getName());
            }
            HttpService httpService = null;
            if (this.conf.getServerConf().isHttpServerEnabled()) {
                BKHttpServiceProvider provider = new BKHttpServiceProvider.Builder().setBookieServer(bookieService.getServer()).setServerConfiguration(this.conf.getServerConf()).setStatsProvider(this.statsProvider).setLedgerManagerFactory(this.ledgerManagerFactory).build();
                httpService = new HttpService(provider, this.conf, rootStatsLogger);
                serverBuilder.addComponent(httpService);
                log.info("Load lifecycle component : {}", (Object)httpService.getName());
            }
            if (null != (extraComponents = this.conf.getServerConf().getExtraServerComponents())) {
                try {
                    List<ServerLifecycleComponent> components = ServerLifecycleComponent.loadServerComponents(extraComponents, this.conf, rootStatsLogger);
                    for (ServerLifecycleComponent component : components) {
                        serverBuilder.addComponent(component);
                        log.info("Load lifecycle component : {}", (Object)component.getName());
                    }
                }
                catch (Exception e) {
                    if (this.conf.getServerConf().getIgnoreExtraServerComponentsStartupFailures()) {
                        log.info("Failed to load extra components '{}' - {}. Continuing without those components.", (Object)StringUtils.join(extraComponents), (Object)e.getMessage());
                    }
                    throw e;
                }
            }
            return new EmbeddedServer(serverBuilder.build(), this.statsProvider, this.registrationManager, this.ledgerManagerFactory, this.diskChecker, this.ledgerDirsManager, this.indexDirsManager, bookieService, autoRecoveryService, dataIntegrityService, httpService);
        }

        private static BookieServiceInfo buildBookieServiceInfo(ComponentInfoPublisher componentInfoPublisher) {
            List<BookieServiceInfo.Endpoint> endpoints = componentInfoPublisher.getEndpoints().values().stream().map(e -> new BookieServiceInfo.Endpoint(e.getId(), e.getPort(), e.getHost(), e.getProtocol(), e.getAuth(), e.getExtensions())).collect(Collectors.toList());
            return new BookieServiceInfo(componentInfoPublisher.getProperties(), endpoints);
        }
    }
}

