/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.bookkeeper.server.component;

import dlshade.com.google.common.collect.Lists;
import dlshade.org.apache.bookkeeper.common.annotation.InterfaceStability;
import dlshade.org.apache.bookkeeper.common.component.AbstractLifecycleComponent;
import dlshade.org.apache.bookkeeper.common.util.ReflectionUtils;
import dlshade.org.apache.bookkeeper.server.conf.BookieConfiguration;
import dlshade.org.apache.bookkeeper.stats.StatsLogger;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;

@InterfaceStability.Evolving
public abstract class ServerLifecycleComponent
extends AbstractLifecycleComponent<BookieConfiguration> {
    public static List<ServerLifecycleComponent> loadServerComponents(String[] componentClassNames, BookieConfiguration conf, StatsLogger statsLogger) {
        ArrayList<Class<ServerLifecycleComponent>> componentClasses = Lists.newArrayListWithExpectedSize(componentClassNames.length);
        for (String componentClsName : componentClassNames) {
            componentClasses.add(ReflectionUtils.forName(componentClsName, ServerLifecycleComponent.class));
        }
        return Lists.transform(componentClasses, cls -> ServerLifecycleComponent.newComponent(cls, conf, statsLogger));
    }

    static ServerLifecycleComponent newComponent(Class<? extends ServerLifecycleComponent> theCls, BookieConfiguration conf, StatsLogger statsLogger) {
        try {
            Constructor<? extends ServerLifecycleComponent> constructor = theCls.getConstructor(BookieConfiguration.class, StatsLogger.class);
            constructor.setAccessible(true);
            return constructor.newInstance(conf, statsLogger);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected ServerLifecycleComponent(String componentName, BookieConfiguration conf, StatsLogger statsLogger) {
        super(componentName, conf, statsLogger);
    }
}

