/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.bookkeeper.server.http.service;

import dlshade.com.google.common.base.Preconditions;
import dlshade.org.apache.bookkeeper.client.BookKeeperAdmin;
import dlshade.org.apache.bookkeeper.common.util.JsonUtil;
import dlshade.org.apache.bookkeeper.conf.ServerConfiguration;
import dlshade.org.apache.bookkeeper.http.HttpServer;
import dlshade.org.apache.bookkeeper.http.service.HttpEndpointService;
import dlshade.org.apache.bookkeeper.http.service.HttpServiceRequest;
import dlshade.org.apache.bookkeeper.http.service.HttpServiceResponse;
import dlshade.org.apache.bookkeeper.net.BookieId;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecommissionService
implements HttpEndpointService {
    static final Logger LOG = LoggerFactory.getLogger(DecommissionService.class);
    protected ServerConfiguration conf;
    protected BookKeeperAdmin bka;
    protected ExecutorService executor;

    public DecommissionService(ServerConfiguration conf, BookKeeperAdmin bka, ExecutorService executor) {
        Preconditions.checkNotNull(conf);
        this.conf = conf;
        this.bka = bka;
        this.executor = executor;
    }

    public HttpServiceResponse handle(HttpServiceRequest request) throws Exception {
        HttpServiceResponse response = new HttpServiceResponse();
        if (HttpServer.Method.PUT == request.getMethod()) {
            String requestBody = request.getBody();
            if (requestBody == null) {
                response.setCode(HttpServer.StatusCode.NOT_FOUND);
                response.setBody("Null request body for DecommissionService.");
                return response;
            }
            HashMap configMap = JsonUtil.fromJson(requestBody, HashMap.class);
            if (configMap != null && configMap.containsKey("bookie_src")) {
                try {
                    BookieId bookieSrc = BookieId.parse((String)configMap.get("bookie_src"));
                    this.executor.execute(() -> {
                        try {
                            LOG.info("Start decommissioning bookie.");
                            this.bka.decommissionBookie(bookieSrc);
                            LOG.info("Complete decommissioning bookie.");
                        }
                        catch (Exception e) {
                            LOG.error("Error handling decommissionBookie: {}.", (Object)bookieSrc, (Object)e);
                        }
                    });
                    response.setCode(HttpServer.StatusCode.OK);
                    response.setBody("Success send decommission Bookie command " + bookieSrc);
                    return response;
                }
                catch (Exception e) {
                    LOG.error("Exception occurred while decommissioning bookie: ", (Throwable)e);
                    response.setCode(HttpServer.StatusCode.NOT_FOUND);
                    response.setBody("Exception when send decommission command." + e.getMessage());
                    return response;
                }
            }
            response.setCode(HttpServer.StatusCode.NOT_FOUND);
            response.setBody("Request body not contains bookie_src.");
            return response;
        }
        response.setCode(HttpServer.StatusCode.NOT_FOUND);
        response.setBody("Not found method. Should be PUT method");
        return response;
    }
}

