/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.bookkeeper.server.http.service;

import dlshade.com.google.common.base.Preconditions;
import dlshade.org.apache.bookkeeper.client.BookKeeper;
import dlshade.org.apache.bookkeeper.common.util.JsonUtil;
import dlshade.org.apache.bookkeeper.conf.ClientConfiguration;
import dlshade.org.apache.bookkeeper.conf.ServerConfiguration;
import dlshade.org.apache.bookkeeper.http.HttpServer;
import dlshade.org.apache.bookkeeper.http.service.HttpEndpointService;
import dlshade.org.apache.bookkeeper.http.service.HttpServiceRequest;
import dlshade.org.apache.bookkeeper.http.service.HttpServiceResponse;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteLedgerService
implements HttpEndpointService {
    static final Logger LOG = LoggerFactory.getLogger(DeleteLedgerService.class);
    protected ServerConfiguration conf;

    public DeleteLedgerService(ServerConfiguration conf) {
        Preconditions.checkNotNull(conf);
        this.conf = conf;
    }

    public HttpServiceResponse handle(HttpServiceRequest request) throws Exception {
        HttpServiceResponse response = new HttpServiceResponse();
        if (HttpServer.Method.DELETE == request.getMethod()) {
            Map params = request.getParams();
            if (params != null && params.containsKey("ledger_id")) {
                ClientConfiguration clientConf = new ClientConfiguration();
                clientConf.addConfiguration((Configuration)this.conf);
                BookKeeper bk = new BookKeeper(clientConf);
                Long ledgerId = Long.parseLong((String)params.get("ledger_id"));
                bk.deleteLedger(ledgerId);
                String output = "Deleted ledger: " + ledgerId;
                String jsonResponse = JsonUtil.toJson(output);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("output body:" + jsonResponse);
                }
                response.setBody(jsonResponse);
                response.setCode(HttpServer.StatusCode.OK);
                return response;
            }
            response.setCode(HttpServer.StatusCode.NOT_FOUND);
            response.setBody("Not ledger found. Should provide ledger_id=<id>");
            return response;
        }
        response.setCode(HttpServer.StatusCode.NOT_FOUND);
        response.setBody("Not found method. Should be DELETE method");
        return response;
    }
}

