/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.bookkeeper.server.http.service;

import dlshade.com.google.common.base.Preconditions;
import dlshade.com.google.common.collect.Maps;
import dlshade.org.apache.bookkeeper.client.BookKeeperAdmin;
import dlshade.org.apache.bookkeeper.common.util.JsonUtil;
import dlshade.org.apache.bookkeeper.conf.ServerConfiguration;
import dlshade.org.apache.bookkeeper.http.HttpServer;
import dlshade.org.apache.bookkeeper.http.service.HttpEndpointService;
import dlshade.org.apache.bookkeeper.http.service.HttpServiceRequest;
import dlshade.org.apache.bookkeeper.http.service.HttpServiceResponse;
import dlshade.org.apache.bookkeeper.net.BookieId;
import dlshade.org.apache.bookkeeper.net.BookieSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListBookiesService
implements HttpEndpointService {
    static final Logger LOG = LoggerFactory.getLogger(ListBookiesService.class);
    protected ServerConfiguration conf;
    protected BookKeeperAdmin bka;

    public ListBookiesService(ServerConfiguration conf, BookKeeperAdmin bka) {
        Preconditions.checkNotNull(conf);
        this.conf = conf;
        this.bka = bka;
    }

    public HttpServiceResponse handle(HttpServiceRequest request) throws Exception {
        HttpServiceResponse response = new HttpServiceResponse();
        if (HttpServer.Method.GET == request.getMethod()) {
            boolean printHostname;
            ArrayList<BookieId> bookies = new ArrayList<BookieId>();
            Map params = request.getParams();
            boolean readOnly = params != null && params.containsKey("type") && ((String)params.get("type")).equals("ro");
            boolean bl = printHostname = params != null && params.containsKey("print_hostnames") && ((String)params.get("print_hostnames")).equals("true");
            if (readOnly) {
                bookies.addAll(this.bka.getReadOnlyBookies());
            } else {
                bookies.addAll(this.bka.getAvailableBookies());
            }
            HashMap<String, String> output = Maps.newHashMap();
            for (BookieId b : bookies) {
                String hostname = null;
                if (printHostname) {
                    BookieSocketAddress resolved = this.bka.getBookieAddressResolver().resolve(b);
                    hostname = resolved.getHostName();
                }
                output.putIfAbsent(b.toString(), hostname);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("bookie: " + b + " hostname:" + hostname);
            }
            String jsonResponse = JsonUtil.toJson(output);
            response.setBody(jsonResponse);
            response.setCode(HttpServer.StatusCode.OK);
            return response;
        }
        response.setCode(HttpServer.StatusCode.NOT_FOUND);
        response.setBody("Not found method. Should be GET method");
        return response;
    }
}

