/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.bookkeeper.server.http.service;

import dlshade.com.google.common.base.Preconditions;
import dlshade.com.google.common.collect.Lists;
import dlshade.org.apache.bookkeeper.common.util.JsonUtil;
import dlshade.org.apache.bookkeeper.conf.ServerConfiguration;
import dlshade.org.apache.bookkeeper.http.HttpServer;
import dlshade.org.apache.bookkeeper.http.service.HttpEndpointService;
import dlshade.org.apache.bookkeeper.http.service.HttpServiceRequest;
import dlshade.org.apache.bookkeeper.http.service.HttpServiceResponse;
import dlshade.org.apache.bookkeeper.meta.LedgerManagerFactory;
import dlshade.org.apache.bookkeeper.meta.LedgerUnderreplicationManager;
import dlshade.org.apache.bookkeeper.meta.UnderreplicatedLedger;
import dlshade.org.apache.commons.lang.StringUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListUnderReplicatedLedgerService
implements HttpEndpointService {
    static final Logger LOG = LoggerFactory.getLogger(ListUnderReplicatedLedgerService.class);
    protected ServerConfiguration conf;
    private final LedgerManagerFactory ledgerManagerFactory;

    public ListUnderReplicatedLedgerService(ServerConfiguration conf, LedgerManagerFactory ledgerManagerFactory) {
        Preconditions.checkNotNull(conf);
        this.conf = conf;
        this.ledgerManagerFactory = ledgerManagerFactory;
    }

    public HttpServiceResponse handle(HttpServiceRequest request) throws Exception {
        HttpServiceResponse response = new HttpServiceResponse();
        Map params = request.getParams();
        if (HttpServer.Method.GET == request.getMethod()) {
            boolean printMissingReplica = false;
            String includingBookieId = params != null && params.containsKey("missingreplica") ? (String)params.get("missingreplica") : null;
            String excludingBookieId = params != null && params.containsKey("excludingmissingreplica") ? (String)params.get("excludingmissingreplica") : null;
            if (params != null && params.containsKey("printmissingreplica")) {
                printMissingReplica = true;
            }
            Predicate<List<String>> predicate = null;
            if (!StringUtils.isBlank(includingBookieId) && !StringUtils.isBlank(excludingBookieId)) {
                predicate = replicasList -> replicasList.contains(includingBookieId) && !replicasList.contains(excludingBookieId);
            } else if (!StringUtils.isBlank(includingBookieId)) {
                predicate = replicasList -> replicasList.contains(includingBookieId);
            } else if (!StringUtils.isBlank(excludingBookieId)) {
                predicate = replicasList -> !replicasList.contains(excludingBookieId);
            }
            try {
                boolean hasURLedgers = false;
                ArrayList<Long> outputLedgers = null;
                LinkedHashMap<Long, List<String>> outputLedgersWithMissingReplica = null;
                LedgerUnderreplicationManager underreplicationManager = this.ledgerManagerFactory.newLedgerUnderreplicationManager();
                Iterator<UnderreplicatedLedger> iter = underreplicationManager.listLedgersToRereplicate(predicate);
                hasURLedgers = iter.hasNext();
                if (hasURLedgers) {
                    if (printMissingReplica) {
                        outputLedgersWithMissingReplica = new LinkedHashMap<Long, List<String>>();
                    } else {
                        outputLedgers = Lists.newArrayList();
                    }
                }
                while (iter.hasNext()) {
                    if (printMissingReplica) {
                        UnderreplicatedLedger underreplicatedLedger = iter.next();
                        outputLedgersWithMissingReplica.put(underreplicatedLedger.getLedgerId(), underreplicatedLedger.getReplicaList());
                        continue;
                    }
                    outputLedgers.add(iter.next().getLedgerId());
                }
                if (!hasURLedgers) {
                    response.setCode(HttpServer.StatusCode.NOT_FOUND);
                    response.setBody("No under replicated ledgers found");
                    return response;
                }
                response.setCode(HttpServer.StatusCode.OK);
                String jsonResponse = JsonUtil.toJson(printMissingReplica ? outputLedgersWithMissingReplica : outputLedgers);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("output body: " + jsonResponse);
                }
                response.setBody(jsonResponse);
                return response;
            }
            catch (Exception e) {
                LOG.error("Exception occurred while listing under replicated ledgers", (Throwable)e);
                response.setCode(HttpServer.StatusCode.NOT_FOUND);
                response.setBody("Exception when get." + e.getMessage());
                return response;
            }
        }
        response.setCode(HttpServer.StatusCode.NOT_FOUND);
        response.setBody("Not found method. Should be GET method");
        return response;
    }
}

