/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.bookkeeper.server.http.service;

import dlshade.com.google.common.base.Preconditions;
import dlshade.org.apache.bookkeeper.common.util.JsonUtil;
import dlshade.org.apache.bookkeeper.http.HttpServer;
import dlshade.org.apache.bookkeeper.http.service.HttpEndpointService;
import dlshade.org.apache.bookkeeper.http.service.HttpServiceRequest;
import dlshade.org.apache.bookkeeper.http.service.HttpServiceResponse;
import dlshade.org.apache.bookkeeper.proto.BookieServer;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResumeCompactionService
implements HttpEndpointService {
    static final Logger LOG = LoggerFactory.getLogger(ResumeCompactionService.class);
    protected BookieServer bookieServer;

    public ResumeCompactionService(BookieServer bookieServer) {
        Preconditions.checkNotNull(bookieServer);
        this.bookieServer = bookieServer;
    }

    public HttpServiceResponse handle(HttpServiceRequest request) throws Exception {
        HttpServiceResponse response = new HttpServiceResponse();
        if (HttpServer.Method.PUT == request.getMethod()) {
            String requestBody = request.getBody();
            if (null == requestBody) {
                return new HttpServiceResponse("Empty request body", HttpServer.StatusCode.BAD_REQUEST);
            }
            Map configMap = JsonUtil.fromJson(requestBody, HashMap.class);
            Boolean resumeMajor = (Boolean)configMap.get("resumeMajor");
            Boolean resumeMinor = (Boolean)configMap.get("resumeMinor");
            if (resumeMajor == null && resumeMinor == null) {
                return new HttpServiceResponse("No resumeMajor or resumeMinor params found", HttpServer.StatusCode.BAD_REQUEST);
            }
            String output = "";
            if (resumeMajor != null && resumeMajor.booleanValue()) {
                output = "Resume majorGC on BookieServer: " + this.bookieServer.toString();
                this.bookieServer.getBookie().getLedgerStorage().resumeMajorGC();
            }
            if (resumeMinor != null && resumeMinor.booleanValue()) {
                output = output + ", Resume minorGC on BookieServer: " + this.bookieServer.toString();
                this.bookieServer.getBookie().getLedgerStorage().resumeMinorGC();
            }
            String jsonResponse = JsonUtil.toJson(output);
            if (LOG.isDebugEnabled()) {
                LOG.debug("output body:" + jsonResponse);
            }
            response.setBody(jsonResponse);
            response.setCode(HttpServer.StatusCode.OK);
            return response;
        }
        response.setCode(HttpServer.StatusCode.NOT_FOUND);
        response.setBody("Not found method. Should be PUT to resume major or minor compaction, Or GET to get compaction state.");
        return response;
    }
}

