/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.bookkeeper.server.service;

import dlshade.org.apache.bookkeeper.bookie.Bookie;
import dlshade.org.apache.bookkeeper.bookie.UncleanShutdownDetection;
import dlshade.org.apache.bookkeeper.common.allocator.ByteBufAllocatorWithOomHandler;
import dlshade.org.apache.bookkeeper.common.component.ComponentInfoPublisher;
import dlshade.org.apache.bookkeeper.net.BookieSocketAddress;
import dlshade.org.apache.bookkeeper.proto.BookieServer;
import dlshade.org.apache.bookkeeper.server.component.ServerLifecycleComponent;
import dlshade.org.apache.bookkeeper.server.conf.BookieConfiguration;
import dlshade.org.apache.bookkeeper.stats.StatsLogger;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BookieService
extends ServerLifecycleComponent {
    private static final Logger log = LoggerFactory.getLogger(BookieService.class);
    public static final String NAME = "bookie-server";
    private final BookieServer server;
    private final ByteBufAllocatorWithOomHandler allocator;

    public BookieService(BookieConfiguration conf, Bookie bookie, StatsLogger statsLogger, ByteBufAllocatorWithOomHandler allocator, UncleanShutdownDetection uncleanShutdownDetection) throws Exception {
        super(NAME, conf, statsLogger);
        this.server = new BookieServer(conf.getServerConf(), bookie, statsLogger, allocator, uncleanShutdownDetection);
        this.allocator = allocator;
    }

    @Override
    public void setExceptionHandler(Thread.UncaughtExceptionHandler handler) {
        super.setExceptionHandler(handler);
        this.server.setExceptionHandler(handler);
        this.allocator.setOomHandler(ex -> {
            try {
                log.error("Unable to allocate memory, exiting bookie", (Throwable)ex);
            }
            finally {
                if (this.uncaughtExceptionHandler != null) {
                    this.uncaughtExceptionHandler.uncaughtException(Thread.currentThread(), (Throwable)ex);
                }
            }
        });
    }

    public BookieServer getServer() {
        return this.server;
    }

    @Override
    protected void doStart() {
        try {
            this.server.start();
        }
        catch (IOException | InterruptedException exc) {
            throw new RuntimeException("Failed to start bookie server", exc);
        }
    }

    @Override
    protected void doStop() {
    }

    @Override
    protected void doClose() throws IOException {
        this.server.shutdown();
    }

    @Override
    public void publishInfo(ComponentInfoPublisher componentInfoPublisher) {
        try {
            BookieSocketAddress localAddress = this.getServer().getLocalAddress();
            ArrayList<String> extensions = new ArrayList<String>();
            if (((BookieConfiguration)this.conf).getServerConf().getTLSProviderFactoryClass() != null) {
                extensions.add("tls");
            }
            ComponentInfoPublisher.EndpointInfo endpoint = new ComponentInfoPublisher.EndpointInfo("bookie", localAddress.getPort(), localAddress.getHostName(), "bookie-rpc", null, extensions);
            componentInfoPublisher.publishEndpoint(endpoint);
        }
        catch (UnknownHostException err) {
            log.error("Cannot compute local address", (Throwable)err);
        }
    }
}

