/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.bookkeeper.tools.cli.commands.autorecovery;

import dlshade.com.google.common.util.concurrent.UncheckedExecutionException;
import dlshade.org.apache.bookkeeper.client.BKException;
import dlshade.org.apache.bookkeeper.client.BookKeeperAdmin;
import dlshade.org.apache.bookkeeper.conf.ClientConfiguration;
import dlshade.org.apache.bookkeeper.conf.ServerConfiguration;
import dlshade.org.apache.bookkeeper.net.BookieId;
import dlshade.org.apache.bookkeeper.tools.cli.helpers.BookieCommand;
import dlshade.org.apache.bookkeeper.tools.framework.CliFlags;
import dlshade.org.apache.bookkeeper.tools.framework.CliSpec;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WhoIsAuditorCommand
extends BookieCommand<CliFlags> {
    static final Logger LOG = LoggerFactory.getLogger(WhoIsAuditorCommand.class);
    private static final String NAME = "whoisauditor";
    private static final String DESC = "Print the node which holds the auditor lock.";
    private BookKeeperAdmin bka;

    public WhoIsAuditorCommand() {
        this((BookKeeperAdmin)null);
    }

    public WhoIsAuditorCommand(BookKeeperAdmin bka) {
        super(CliSpec.newBuilder().withName(NAME).withDescription(DESC).withFlags(new CliFlags()).build());
        this.bka = bka;
    }

    @Override
    public boolean apply(ServerConfiguration conf, CliFlags cmdFlags) {
        try {
            return this.getAuditor(conf);
        }
        catch (Exception e) {
            throw new UncheckedExecutionException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getAuditor(ServerConfiguration conf) throws BKException, InterruptedException, IOException {
        BookieId bookieId;
        ClientConfiguration clientConfiguration = new ClientConfiguration(conf);
        if (this.bka != null) {
            bookieId = this.bka.getCurrentAuditor();
        } else {
            try (BookKeeperAdmin bka = new BookKeeperAdmin(clientConfiguration);){
                bookieId = bka.getCurrentAuditor();
            }
        }
        if (bookieId == null) {
            LOG.info("No auditor elected");
            return false;
        }
        LOG.info("Auditor: " + bookieId);
        return true;
    }
}

