/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.bookkeeper.tools.cli.commands.bookie;

import com.beust.jcommander.Parameter;
import dlshade.org.apache.bookkeeper.bookie.storage.ldb.LedgersIndexCheckOp;
import dlshade.org.apache.bookkeeper.conf.ServerConfiguration;
import dlshade.org.apache.bookkeeper.tools.cli.helpers.BookieCommand;
import dlshade.org.apache.bookkeeper.tools.framework.CliFlags;
import dlshade.org.apache.bookkeeper.tools.framework.CliSpec;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckDBLedgersIndexCommand
extends BookieCommand<CheckLedgersIndexFlags> {
    static final Logger LOG = LoggerFactory.getLogger(CheckDBLedgersIndexCommand.class);
    private static final String NAME = "check-db-ledgers-index";
    private static final String DESC = "Check the DBLedgerStorage ledgers index integrity by performing a read scan";

    public CheckDBLedgersIndexCommand() {
        this(new CheckLedgersIndexFlags());
    }

    public CheckDBLedgersIndexCommand(CheckLedgersIndexFlags flags) {
        super(CliSpec.newBuilder().withName(NAME).withDescription(DESC).withFlags(flags).build());
    }

    @Override
    public boolean apply(ServerConfiguration conf, CheckLedgersIndexFlags cmdFlags) {
        LOG.info("=== Checking DBStorage ledgers index by running a read scan ===");
        ServerConfiguration serverConfiguration = new ServerConfiguration(conf);
        try {
            boolean success = new LedgersIndexCheckOp(serverConfiguration, cmdFlags.verbose).initiate();
            if (success) {
                LOG.info("-- Done checking DBStorage ledgers index --");
            } else {
                LOG.info("-- Aborted checking DBStorage ledgers index --");
            }
            return success;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static class CheckLedgersIndexFlags
    extends CliFlags {
        @Parameter(names={"-v", "--verbose"}, description="Verbose logging. Print each ledger.")
        private boolean verbose;

        public CheckLedgersIndexFlags verbose(boolean verbose) {
            this.verbose = verbose;
            return this;
        }
    }
}

