/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.bookkeeper.tools.cli.commands.bookie;

import dlshade.com.google.common.util.concurrent.UncheckedExecutionException;
import dlshade.org.apache.bookkeeper.bookie.Journal;
import dlshade.org.apache.bookkeeper.bookie.LedgerDirsManager;
import dlshade.org.apache.bookkeeper.bookie.LogMark;
import dlshade.org.apache.bookkeeper.conf.ServerConfiguration;
import dlshade.org.apache.bookkeeper.tools.cli.helpers.BookieCommand;
import dlshade.org.apache.bookkeeper.tools.framework.CliFlags;
import dlshade.org.apache.bookkeeper.tools.framework.CliSpec;
import dlshade.org.apache.bookkeeper.util.DiskChecker;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LastMarkCommand
extends BookieCommand<CliFlags> {
    private static final String NAME = "lastmark";
    private static final String DESC = "Print last log marker";
    private static final Logger LOG = LoggerFactory.getLogger(LastMarkCommand.class);

    public LastMarkCommand() {
        super(CliSpec.newBuilder().withName(NAME).withFlags(new CliFlags()).withDescription(DESC).build());
    }

    @Override
    public boolean apply(ServerConfiguration conf, CliFlags flags) {
        try {
            LedgerDirsManager dirsManager = new LedgerDirsManager(conf, conf.getLedgerDirs(), new DiskChecker(conf.getDiskUsageThreshold(), conf.getDiskUsageWarnThreshold()));
            File[] journalDirs = conf.getJournalDirs();
            for (int idx = 0; idx < journalDirs.length; ++idx) {
                Journal journal = new Journal(idx, journalDirs[idx], conf, dirsManager);
                LogMark lastLogMark = journal.getLastLogMark().getCurMark();
                LOG.info("LastLogMark : Journal Id - {}({}.txn), Pos - {}", new Object[]{lastLogMark.getLogFileId(), Long.toHexString(lastLogMark.getLogFileId()), lastLogMark.getLogFileOffset()});
            }
            return true;
        }
        catch (IOException e) {
            throw new UncheckedExecutionException(e.getMessage(), e);
        }
    }
}

