/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.bookkeeper.tools.cli.commands.bookie;

import com.beust.jcommander.Parameter;
import dlshade.com.google.common.util.concurrent.UncheckedExecutionException;
import dlshade.org.apache.bookkeeper.client.BKException;
import dlshade.org.apache.bookkeeper.client.BookKeeperAdmin;
import dlshade.org.apache.bookkeeper.client.api.LedgerMetadata;
import dlshade.org.apache.bookkeeper.conf.ServerConfiguration;
import dlshade.org.apache.bookkeeper.meta.LedgerManager;
import dlshade.org.apache.bookkeeper.meta.MetadataDrivers;
import dlshade.org.apache.bookkeeper.meta.exceptions.MetadataException;
import dlshade.org.apache.bookkeeper.net.BookieId;
import dlshade.org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import dlshade.org.apache.bookkeeper.tools.cli.helpers.BookieCommand;
import dlshade.org.apache.bookkeeper.tools.framework.CliFlags;
import dlshade.org.apache.bookkeeper.tools.framework.CliSpec;
import dlshade.org.apache.bookkeeper.util.LedgerIdFormatter;
import dlshade.org.apache.commons.lang.StringUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.UnknownHostException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"})
public class ListLedgersCommand
extends BookieCommand<ListLedgersFlags> {
    private static final Logger LOG = LoggerFactory.getLogger(ListLedgersCommand.class);
    private static final String NAME = "listledgers";
    private static final String DESC = "List all ledgers on the cluster (this may take a long time).";
    private static final String DEFAULT = "";
    private LedgerIdFormatter ledgerIdFormatter;

    public ListLedgersCommand() {
        this(new ListLedgersFlags());
    }

    public ListLedgersCommand(LedgerIdFormatter ledgerIdFormatter) {
        this(new ListLedgersFlags());
        this.ledgerIdFormatter = ledgerIdFormatter;
    }

    public ListLedgersCommand(ListLedgersFlags flags) {
        super(CliSpec.newBuilder().withName(NAME).withDescription(DESC).withFlags(flags).build());
    }

    @Override
    public boolean apply(ServerConfiguration conf, ListLedgersFlags cmdFlags) {
        this.initLedgerFrommat(conf, cmdFlags);
        try {
            this.handler(conf, cmdFlags);
        }
        catch (UnknownHostException e) {
            LOG.error("Bookie id error");
            return false;
        }
        catch (MetadataException | ExecutionException e) {
            throw new UncheckedExecutionException(e.getMessage(), e);
        }
        return true;
    }

    private void initLedgerFrommat(ServerConfiguration conf, ListLedgersFlags cmdFlags) {
        if (this.ledgerIdFormatter != null) {
            return;
        }
        this.ledgerIdFormatter = !cmdFlags.ledgerIdFormatter.equals(DEFAULT) ? LedgerIdFormatter.newLedgerIdFormatter(cmdFlags.ledgerIdFormatter, conf) : LedgerIdFormatter.newLedgerIdFormatter(conf);
    }

    public boolean handler(ServerConfiguration conf, ListLedgersFlags flags) throws UnknownHostException, MetadataException, ExecutionException {
        BookieId bookieAddress = StringUtils.isBlank(flags.bookieId) ? null : BookieId.parse(flags.bookieId);
        MetadataDrivers.runFunctionWithLedgerManagerFactory(conf, mFactory -> {
            try (LedgerManager ledgerManager = mFactory.newLedgerManager();){
                AtomicInteger returnCode = new AtomicInteger(0);
                CountDownLatch processDone = new CountDownLatch(1);
                BookkeeperInternalCallbacks.Processor<Long> ledgerProcessor = (ledgerId, cb) -> {
                    if (!flags.meta && bookieAddress == null) {
                        this.printLedgerMetadata((long)ledgerId, null, false);
                        cb.processResult(0, null, null);
                    } else {
                        ledgerManager.readLedgerMetadata((long)ledgerId).whenComplete((metadata, exception) -> {
                            if (exception == null) {
                                if (bookieAddress == null || BookKeeperAdmin.areEntriesOfLedgerStoredInTheBookie((long)ledgerId, bookieAddress, (LedgerMetadata)metadata.getValue())) {
                                    ListLedgersCommand listLedgersCommand = this;
                                    synchronized (listLedgersCommand) {
                                        this.printLedgerMetadata((long)ledgerId, (LedgerMetadata)metadata.getValue(), flags.meta);
                                    }
                                }
                                cb.processResult(0, null, null);
                            } else if (BKException.getExceptionCode(exception) == -7 || BKException.getExceptionCode(exception) == -25) {
                                cb.processResult(0, null, null);
                            } else {
                                LOG.error("Unable to read the ledger: {} information", ledgerId);
                                cb.processResult(BKException.getExceptionCode(exception), null, null);
                            }
                        });
                    }
                };
                ledgerManager.asyncProcessLedgers(ledgerProcessor, (rc, s, obj) -> {
                    returnCode.set(rc);
                    processDone.countDown();
                }, null, 0, -1);
                processDone.await();
                if (returnCode.get() != 0) {
                    LOG.error("Received error return value while processing ledgers: {}", (Object)returnCode.get());
                    throw BKException.create(returnCode.get());
                }
            }
            catch (Exception ioe) {
                LOG.error("Received Exception while processing ledgers", (Throwable)ioe);
                throw new UncheckedExecutionException(ioe);
            }
            return null;
        });
        return true;
    }

    private void printLedgerMetadata(long ledgerId, LedgerMetadata md, boolean printMeta) {
        LOG.info("ledgerID: {}", (Object)this.ledgerIdFormatter.formatLedgerId(ledgerId));
        if (printMeta) {
            LOG.info("{}", (Object)md.toString());
        }
    }

    public static class ListLedgersFlags
    extends CliFlags {
        @Parameter(names={"-m", "--meta"}, description="Print metadata")
        private boolean meta;
        @Parameter(names={"-id", "--bookieid"}, description="List ledgers residing in this bookie")
        private String bookieId;
        @Parameter(names={"-l", "--ledgerIdFormatter"}, description="Set ledger id formatter")
        private String ledgerIdFormatter = "";

        public ListLedgersFlags meta(boolean meta) {
            this.meta = meta;
            return this;
        }

        public ListLedgersFlags bookieId(String bookieId) {
            this.bookieId = bookieId;
            return this;
        }

        public ListLedgersFlags ledgerIdFormatter(String ledgerIdFormatter) {
            this.ledgerIdFormatter = ledgerIdFormatter;
            return this;
        }
    }
}

