/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.bookkeeper.tools.cli.commands.bookie;

import dlshade.com.google.common.util.concurrent.UncheckedExecutionException;
import dlshade.org.apache.bookkeeper.bookie.BookieImpl;
import dlshade.org.apache.bookkeeper.bookie.LedgerStorage;
import dlshade.org.apache.bookkeeper.conf.ServerConfiguration;
import dlshade.org.apache.bookkeeper.tools.cli.helpers.BookieCommand;
import dlshade.org.apache.bookkeeper.tools.framework.CliFlags;
import dlshade.org.apache.bookkeeper.tools.framework.CliSpec;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalConsistencyCheckCommand
extends BookieCommand<CliFlags> {
    static final Logger LOG = LoggerFactory.getLogger(LocalConsistencyCheckCommand.class);
    private static final String NAME = "localconsistencycheck";
    private static final String DESC = "Validate Ledger Storage internal metadata";

    public LocalConsistencyCheckCommand() {
        super(CliSpec.newBuilder().withName(NAME).withDescription(DESC).withFlags(new CliFlags()).build());
    }

    @Override
    public boolean apply(ServerConfiguration conf, CliFlags cmdFlags) {
        try {
            return this.check(conf);
        }
        catch (IOException e) {
            throw new UncheckedExecutionException(e.getMessage(), e);
        }
    }

    private boolean check(ServerConfiguration conf) throws IOException {
        LOG.info("=== Performing local consistency check ===");
        ServerConfiguration serverConfiguration = new ServerConfiguration(conf);
        LedgerStorage ledgerStorage = BookieImpl.mountLedgerStorageOffline(serverConfiguration, null);
        List<LedgerStorage.DetectedInconsistency> errors = ledgerStorage.localConsistencyCheck(Optional.empty());
        if (errors.size() > 0) {
            LOG.info("=== Check returned errors: ===");
            for (LedgerStorage.DetectedInconsistency error : errors) {
                LOG.error("Ledger {}, entry {}: ", new Object[]{error.getLedgerId(), error.getEntryId(), error.getException()});
            }
            return false;
        }
        LOG.info("=== Check passed ===");
        return true;
    }
}

