/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.bookkeeper.tools.cli.commands.bookie;

import com.beust.jcommander.Parameter;
import dlshade.org.apache.bookkeeper.bookie.storage.ldb.LedgersIndexRebuildOp;
import dlshade.org.apache.bookkeeper.conf.ServerConfiguration;
import dlshade.org.apache.bookkeeper.tools.cli.helpers.BookieCommand;
import dlshade.org.apache.bookkeeper.tools.framework.CliFlags;
import dlshade.org.apache.bookkeeper.tools.framework.CliSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RebuildDBLedgersIndexCommand
extends BookieCommand<RebuildLedgersIndexFlags> {
    static final Logger LOG = LoggerFactory.getLogger(RebuildDBLedgersIndexCommand.class);
    private static final String NAME = "rebuild-db-ledgers-index";
    private static final String DESC = "Rebuild DBLedgerStorage ledgers index by scanning the journal and entry logs (sets all ledgers to fenced)";

    public RebuildDBLedgersIndexCommand() {
        this(new RebuildLedgersIndexFlags());
    }

    public RebuildDBLedgersIndexCommand(RebuildLedgersIndexFlags flags) {
        super(CliSpec.newBuilder().withName(NAME).withDescription(DESC).withFlags(flags).build());
    }

    @Override
    public boolean apply(ServerConfiguration conf, RebuildLedgersIndexFlags cmdFlags) {
        LOG.info("=== Rebuilding DBStorage ledgers index ===");
        ServerConfiguration serverConfiguration = new ServerConfiguration(conf);
        boolean success = new LedgersIndexRebuildOp(serverConfiguration, cmdFlags.verbose).initiate();
        if (success) {
            LOG.info("-- Done rebuilding DBStorage ledgers index --");
        } else {
            LOG.info("-- Aborted rebuilding DBStorage ledgers index --");
        }
        return success;
    }

    public static class RebuildLedgersIndexFlags
    extends CliFlags {
        @Parameter(names={"-v", "--verbose"}, description="Verbose logging. Print each ledger id found and added to the rebuilt index")
        private boolean verbose;

        public RebuildLedgersIndexFlags verbose(boolean verbose) {
            this.verbose = verbose;
            return this;
        }
    }
}

