/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.bookkeeper.tools.cli.commands.bookie;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.converters.CommaParameterSplitter;
import dlshade.com.google.common.util.concurrent.UncheckedExecutionException;
import dlshade.org.apache.bookkeeper.bookie.InterleavedStorageRegenerateIndexOp;
import dlshade.org.apache.bookkeeper.conf.ServerConfiguration;
import dlshade.org.apache.bookkeeper.tools.cli.helpers.BookieCommand;
import dlshade.org.apache.bookkeeper.tools.framework.CliFlags;
import dlshade.org.apache.bookkeeper.tools.framework.CliSpec;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegenerateInterleavedStorageIndexFileCommand
extends BookieCommand<RISIFFlags> {
    static final Logger LOG = LoggerFactory.getLogger(RegenerateInterleavedStorageIndexFileCommand.class);
    private static final String NAME = "regenerate-interleaved-storage-index-file";
    private static final String DESC = "Regenerate an interleaved storage index file, from available entrylogger files.";
    private static final String DEFAULT = "";

    public RegenerateInterleavedStorageIndexFileCommand() {
        this(new RISIFFlags());
    }

    private RegenerateInterleavedStorageIndexFileCommand(RISIFFlags flags) {
        super(CliSpec.newBuilder().withName(NAME).withDescription(DESC).withFlags(flags).build());
    }

    @Override
    public boolean apply(ServerConfiguration conf, RISIFFlags cmdFlags) {
        try {
            return this.generate(conf, cmdFlags);
        }
        catch (Exception e) {
            throw new UncheckedExecutionException(e.getMessage(), e);
        }
    }

    private boolean generate(ServerConfiguration conf, RISIFFlags flags) throws NoSuchAlgorithmException, IOException {
        byte[] password;
        this.validateFlags(flags);
        if (!flags.password.equals(DEFAULT)) {
            password = flags.password.getBytes(StandardCharsets.UTF_8);
        } else if (!flags.b64Password.equals(DEFAULT)) {
            password = Base64.getDecoder().decode(flags.b64Password);
        } else {
            LOG.error("The password must be specified to regenerate the index file");
            return false;
        }
        Set<Long> ledgerIds = flags.ledgerIds.stream().collect(Collectors.toSet());
        LOG.info("=== Rebuilding index file for {} ===", ledgerIds);
        ServerConfiguration serverConfiguration = new ServerConfiguration(conf);
        InterleavedStorageRegenerateIndexOp i = new InterleavedStorageRegenerateIndexOp(serverConfiguration, ledgerIds, password);
        i.initiate(flags.dryRun);
        LOG.info("-- Done rebuilding index file for {} --", ledgerIds);
        return true;
    }

    private void validateFlags(RISIFFlags flags) {
        if (flags.password == null) {
            flags.password = DEFAULT;
        }
        if (flags.b64Password == null) {
            flags.b64Password = DEFAULT;
        }
    }

    public static class RISIFFlags
    extends CliFlags {
        @Parameter(names={"-p", "--password"}, description="The bookie stores the password in the index file, so we need it to regenerate.This must match the value in the ledger metadata.")
        private String password = "";
        @Parameter(names={"-b", "--b64password"}, description="The password in base64 encoding, for cases where the password is not UTF-8.")
        private String b64Password = "";
        @Parameter(names={"-d", "--dryrun"}, description="Process the entryLogger, but don't write anthing.")
        private boolean dryRun;
        @Parameter(names={"-l", "--ledgerids"}, description="Ledger(s) whose index needs to be regenerated. Multiple can be specified, comma separated.", splitter=CommaParameterSplitter.class)
        private List<Long> ledgerIds;

        public RISIFFlags password(String password) {
            this.password = password;
            return this;
        }

        public RISIFFlags b64Password(String b64Password) {
            this.b64Password = b64Password;
            return this;
        }

        public RISIFFlags dryRun(boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public RISIFFlags ledgerIds(List<Long> ledgerIds) {
            this.ledgerIds = ledgerIds;
            return this;
        }
    }
}

