/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.bookkeeper.tools.cli.commands.bookies;

import com.beust.jcommander.Parameter;
import dlshade.com.google.common.util.concurrent.UncheckedExecutionException;
import dlshade.org.apache.bookkeeper.bookie.BookieException;
import dlshade.org.apache.bookkeeper.bookie.BookieImpl;
import dlshade.org.apache.bookkeeper.bookie.Cookie;
import dlshade.org.apache.bookkeeper.client.BKException;
import dlshade.org.apache.bookkeeper.client.BookKeeperAdmin;
import dlshade.org.apache.bookkeeper.conf.ClientConfiguration;
import dlshade.org.apache.bookkeeper.conf.ServerConfiguration;
import dlshade.org.apache.bookkeeper.discover.RegistrationManager;
import dlshade.org.apache.bookkeeper.meta.MetadataDrivers;
import dlshade.org.apache.bookkeeper.net.BookieId;
import dlshade.org.apache.bookkeeper.tools.cli.helpers.BookieCommand;
import dlshade.org.apache.bookkeeper.tools.framework.CliFlags;
import dlshade.org.apache.bookkeeper.tools.framework.CliSpec;
import dlshade.org.apache.bookkeeper.versioning.Versioned;
import dlshade.org.apache.commons.lang.StringUtils;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecommissionCommand
extends BookieCommand<DecommissionFlags> {
    static final Logger LOG = LoggerFactory.getLogger(DecommissionCommand.class);
    private static final String NAME = "decommission";
    private static final String DESC = "Force trigger the Audittask and make sure all the ledgers stored in the decommissioning bookie are replicated and cookie of the decommissioned bookie is deleted from metadata server.";

    public DecommissionCommand() {
        this(new DecommissionFlags());
    }

    private DecommissionCommand(DecommissionFlags flags) {
        super(CliSpec.newBuilder().withName(NAME).withDescription(DESC).withFlags(flags).build());
    }

    @Override
    public boolean apply(ServerConfiguration conf, DecommissionFlags cmdFlags) {
        try {
            return this.decommission(conf, cmdFlags);
        }
        catch (Exception e) {
            throw new UncheckedExecutionException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean decommission(ServerConfiguration conf, DecommissionFlags flags) throws BKException, InterruptedException, IOException {
        ClientConfiguration adminConf = new ClientConfiguration(conf);
        try (BookKeeperAdmin admin = new BookKeeperAdmin(adminConf);){
            String remoteBookieidToDecommission = flags.remoteBookieIdToDecommission;
            BookieId bookieAddressToDecommission = StringUtils.isBlank(remoteBookieidToDecommission) ? BookieImpl.getBookieId(conf) : BookieId.parse(remoteBookieidToDecommission);
            admin.decommissionBookie(bookieAddressToDecommission);
            LOG.info("The ledgers stored in the given decommissioning bookie: {} are properly replicated", (Object)bookieAddressToDecommission);
            MetadataDrivers.runFunctionWithRegistrationManager(conf, rm -> {
                try {
                    Versioned<Cookie> cookie = Cookie.readFromRegistrationManager(rm, bookieAddressToDecommission);
                    cookie.getValue().deleteFromRegistrationManager((RegistrationManager)rm, bookieAddressToDecommission, cookie.getVersion());
                }
                catch (BookieException.CookieNotFoundException nne) {
                    LOG.warn("No cookie to remove for the decommissioning bookie: {}, it could be deleted already", (Object)bookieAddressToDecommission, (Object)nne);
                }
                catch (BookieException be) {
                    throw new UncheckedExecutionException(be.getMessage(), be);
                }
                return true;
            });
            LOG.info("Cookie of the decommissioned bookie: {} is deleted successfully", (Object)bookieAddressToDecommission);
            boolean bl = true;
            return bl;
        }
    }

    public static class DecommissionFlags
    extends CliFlags {
        @Parameter(names={"-b", "--bookieid"}, description="Decommission a remote bookie")
        private String remoteBookieIdToDecommission;

        public DecommissionFlags remoteBookieIdToDecommission(String remoteBookieIdToDecommission) {
            this.remoteBookieIdToDecommission = remoteBookieIdToDecommission;
            return this;
        }
    }
}

