/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.bookkeeper.tools.cli.commands.bookies;

import com.beust.jcommander.Parameter;
import dlshade.org.apache.bookkeeper.client.BookieAddressResolverDisabled;
import dlshade.org.apache.bookkeeper.client.DefaultBookieAddressResolver;
import dlshade.org.apache.bookkeeper.common.concurrent.FutureUtils;
import dlshade.org.apache.bookkeeper.discover.RegistrationClient;
import dlshade.org.apache.bookkeeper.net.BookieId;
import dlshade.org.apache.bookkeeper.proto.BookieAddressResolver;
import dlshade.org.apache.bookkeeper.tools.cli.helpers.CommandHelpers;
import dlshade.org.apache.bookkeeper.tools.cli.helpers.DiscoveryCommand;
import dlshade.org.apache.bookkeeper.tools.framework.CliFlags;
import dlshade.org.apache.bookkeeper.tools.framework.CliSpec;
import java.util.Collection;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListBookiesCommand
extends DiscoveryCommand<Flags> {
    private static final String NAME = "list";
    private static final String DESC = "List the bookies, which are running as either readwrite or readonly mode.";
    private static final Logger LOG = LoggerFactory.getLogger(ListBookiesCommand.class);

    public ListBookiesCommand() {
        this(new Flags());
    }

    public ListBookiesCommand(Flags flags) {
        super(CliSpec.newBuilder().withName(NAME).withDescription(DESC).withFlags(flags).build());
    }

    @Override
    protected void run(RegistrationClient regClient, Flags flags, boolean bookieAddressResolverEnabled) throws Exception {
        Set<BookieId> bookies;
        if (!(flags.readwrite || flags.readonly || flags.all)) {
            flags.readwrite = true;
            flags.readonly = true;
            flags.all = true;
        }
        BookieAddressResolver bookieAddressResolver = bookieAddressResolverEnabled ? new DefaultBookieAddressResolver(regClient) : new BookieAddressResolverDisabled();
        boolean hasBookies = false;
        if (flags.readwrite && !(bookies = FutureUtils.result(regClient.getWritableBookies()).getValue()).isEmpty()) {
            LOG.info("ReadWrite Bookies :");
            ListBookiesCommand.printBookies(bookies, bookieAddressResolver);
            hasBookies = true;
        }
        if (flags.readonly && !(bookies = FutureUtils.result(regClient.getReadOnlyBookies()).getValue()).isEmpty()) {
            LOG.info("Readonly Bookies :");
            ListBookiesCommand.printBookies(bookies, bookieAddressResolver);
            hasBookies = true;
        }
        if (flags.all && !(bookies = FutureUtils.result(regClient.getAllBookies()).getValue()).isEmpty()) {
            LOG.info("All Bookies :");
            ListBookiesCommand.printBookies(bookies, bookieAddressResolver);
            hasBookies = true;
        }
        if (!hasBookies) {
            LOG.error("No bookie exists!");
        }
    }

    private static void printBookies(Collection<BookieId> bookies, BookieAddressResolver bookieAddressResolver) {
        for (BookieId b : bookies) {
            LOG.info("{}", (Object)CommandHelpers.getBookieSocketAddrStringRepresentation(b, bookieAddressResolver));
        }
    }

    public static class Flags
    extends CliFlags {
        @Parameter(names={"-rw", "--readwrite"}, description="Print readwrite bookies")
        private boolean readwrite = false;
        @Parameter(names={"-ro", "--readonly"}, description="Print readonly bookies")
        private boolean readonly = false;
        @Parameter(names={"-a", "--all"}, description="Print all bookies")
        private boolean all = false;

        public Flags readwrite(boolean readwrite) {
            this.readwrite = readwrite;
            return this;
        }

        public Flags readonly(boolean readonly) {
            this.readonly = readonly;
            return this;
        }

        public Flags all(boolean all) {
            this.all = all;
            return this;
        }
    }
}

