/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.bookkeeper.tools.cli.helpers;

import dlshade.org.apache.bookkeeper.client.api.BookKeeper;
import dlshade.org.apache.bookkeeper.common.net.ServiceURI;
import dlshade.org.apache.bookkeeper.conf.ClientConfiguration;
import dlshade.org.apache.bookkeeper.conf.ServerConfiguration;
import dlshade.org.apache.bookkeeper.tools.common.BKCommand;
import dlshade.org.apache.bookkeeper.tools.common.BKFlags;
import dlshade.org.apache.bookkeeper.tools.framework.CliFlags;
import dlshade.org.apache.bookkeeper.tools.framework.CliSpec;
import org.apache.commons.configuration.CompositeConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ClientCommand<ClientFlagsT extends CliFlags>
extends BKCommand<ClientFlagsT> {
    private static final Logger log = LoggerFactory.getLogger(ClientCommand.class);

    protected ClientCommand(CliSpec<ClientFlagsT> spec) {
        super(spec);
    }

    @Override
    protected boolean apply(ServiceURI serviceURI, CompositeConfiguration conf, BKFlags globalFlags, ClientFlagsT cmdFlags) {
        ClientConfiguration clientConf = new ClientConfiguration();
        clientConf.loadConf(conf);
        if (null != serviceURI) {
            clientConf.setMetadataServiceUri(serviceURI.getUri().toString());
        }
        return this.apply(clientConf, cmdFlags);
    }

    public boolean apply(ServerConfiguration conf, ClientFlagsT cmdFlags) {
        ClientConfiguration clientConf = new ClientConfiguration(conf);
        return this.apply(clientConf, cmdFlags);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean apply(ClientConfiguration conf, ClientFlagsT cmdFlags) {
        try (BookKeeper bk = BookKeeper.newBuilder(conf).build();){
            this.run(bk, cmdFlags);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            log.error("Failed to process command '{}'", (Object)this.name(), (Object)e);
            return false;
        }
    }

    protected abstract void run(BookKeeper var1, ClientFlagsT var2) throws Exception;
}

