/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.bookkeeper.tools.framework;

import dlshade.org.apache.bookkeeper.tools.framework.Cli;
import dlshade.org.apache.bookkeeper.tools.framework.CliFlags;
import dlshade.org.apache.bookkeeper.tools.framework.Command;
import dlshade.org.apache.bookkeeper.tools.framework.CommandUtils;

class HelpCommand<GlobalFlagsT extends CliFlags, CommandFlagsT extends CliFlags>
implements Command<GlobalFlagsT> {
    private final Cli<CommandFlagsT> cli;

    HelpCommand(Cli<CommandFlagsT> cli) {
        this.cli = cli;
    }

    @Override
    public String name() {
        return "help";
    }

    @Override
    public String description() {
        return "Display help information about it";
    }

    @Override
    public Boolean apply(GlobalFlagsT globalFlags, String[] args) throws Exception {
        if (args.length == 0) {
            this.cli.usage();
            return true;
        }
        String cmd = args[0];
        Command command = this.cli.getCommand(cmd);
        if (null != command) {
            command.usage();
        } else {
            this.cli.usage("Command \"" + cmd + "\" is not found.");
        }
        return true;
    }

    @Override
    public void usage() {
        this.cli.console("Help provides help for any command in this cli.");
        this.cli.console("Simply type '" + this.cli.cmdPath() + " help [command]' for full details.");
        this.cli.console("");
        CommandUtils.printUsage(this.cli.console(), this.cli.cmdPath() + " help [command] [options]");
    }
}

