/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.bookkeeper.util;

import dlshade.org.apache.bookkeeper.common.util.affinity.CpuAffinity;
import dlshade.org.apache.bookkeeper.conf.ClientConfiguration;
import dlshade.org.apache.bookkeeper.conf.ServerConfiguration;
import dlshade.org.apache.commons.lang.SystemUtils;
import dlshade.org.apache.commons.lang3.StringUtils;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.incubator.channel.uring.IOUring;
import io.netty.incubator.channel.uring.IOUringEventLoopGroup;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EventLoopUtil {
    private static final Logger log = LoggerFactory.getLogger(EventLoopUtil.class);
    private static final String ENABLE_IO_URING = "enable.io_uring";

    public static EventLoopGroup getClientEventLoopGroup(ClientConfiguration conf, ThreadFactory threadFactory) {
        return EventLoopUtil.getEventLoopGroup(threadFactory, conf.getNumIOThreads(), conf.isBusyWaitEnabled());
    }

    public static EventLoopGroup getServerEventLoopGroup(ServerConfiguration conf, ThreadFactory threadFactory) {
        return EventLoopUtil.getEventLoopGroup(threadFactory, conf.getServerNumIOThreads(), conf.isBusyWaitEnabled());
    }

    public static EventLoopGroup getServerAcceptorGroup(ServerConfiguration conf, ThreadFactory threadFactory) {
        return EventLoopUtil.getEventLoopGroup(threadFactory, conf.getServerNumAcceptorThreads(), false);
    }

    private static EventLoopGroup getEventLoopGroup(ThreadFactory threadFactory, int numThreads, boolean enableBusyWait) {
        if (!SystemUtils.IS_OS_LINUX) {
            return new NioEventLoopGroup(numThreads, threadFactory);
        }
        String enableIoUring = System.getProperty(ENABLE_IO_URING);
        if (StringUtils.equalsAnyIgnoreCase(enableIoUring, "1", "true")) {
            IOUring.ensureAvailability();
            return new IOUringEventLoopGroup(numThreads, threadFactory);
        }
        try {
            if (!enableBusyWait) {
                return new EpollEventLoopGroup(numThreads, threadFactory);
            }
            EpollEventLoopGroup eventLoopGroup = new EpollEventLoopGroup(numThreads, threadFactory, () -> (selectSupplier, hasTasks) -> -3);
            for (int i = 0; i < numThreads; ++i) {
                eventLoopGroup.next().submit(() -> {
                    try {
                        CpuAffinity.acquireCore();
                    }
                    catch (Throwable t) {
                        log.warn("Failed to acquire CPU core for thread {} err {} {}", new Object[]{Thread.currentThread().getName(), t.getMessage(), t});
                    }
                });
            }
            return eventLoopGroup;
        }
        catch (ExceptionInInitializerError | NoClassDefFoundError | UnsatisfiedLinkError e) {
            log.warn("Could not use Netty Epoll event loop: {}", (Object)e.getMessage());
            return new NioEventLoopGroup(numThreads, threadFactory);
        }
    }

    private EventLoopUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

