/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.bookkeeper.util;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import org.slf4j.Logger;

public class IOUtils {
    public static void close(Logger log, Closeable ... closeables) {
        for (Closeable c : closeables) {
            IOUtils.close(log, c);
        }
    }

    public static void close(Logger log, Closeable closeable) {
        block3: {
            if (closeable != null) {
                try {
                    closeable.close();
                }
                catch (IOException e) {
                    if (log == null || !log.isDebugEnabled()) break block3;
                    log.debug("Exception in closing " + closeable, (Throwable)e);
                }
            }
        }
    }

    public static boolean confirmPrompt(String prompt) throws IOException {
        while (true) {
            int c;
            System.out.print(prompt + " (Y or N) ");
            StringBuilder responseBuilder = new StringBuilder();
            while ((c = System.in.read()) != -1 && c != 13 && c != 10) {
                responseBuilder.append((char)c);
            }
            String response = responseBuilder.toString();
            if (response.equalsIgnoreCase("y") || response.equalsIgnoreCase("yes")) {
                return true;
            }
            if (response.equalsIgnoreCase("n") || response.equalsIgnoreCase("no")) {
                return false;
            }
            System.out.println("Invalid input: " + response);
        }
    }

    public static void writeFully(WritableByteChannel bc, ByteBuffer buf) throws IOException {
        do {
            bc.write(buf);
        } while (buf.remaining() > 0);
    }

    public static File createTempDir(String prefix, String suffix) throws IOException {
        return IOUtils.createTempDir(prefix, suffix, null);
    }

    public static File createTempDir(String prefix, String suffix, File dir) throws IOException {
        File tmpDir = File.createTempFile(prefix, suffix, dir);
        if (!tmpDir.delete()) {
            throw new IOException("Couldn't delete directory " + tmpDir);
        }
        if (!tmpDir.mkdir()) {
            throw new IOException("Couldn't create directory " + tmpDir);
        }
        return tmpDir;
    }

    public static File createTempFileAndDeleteOnExit(String prefix, String suffix) throws IOException {
        File tmpDir = File.createTempFile(prefix, suffix);
        tmpDir.deleteOnExit();
        return tmpDir;
    }
}

