/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.bookkeeper.util;

import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;
import java.util.function.ToLongFunction;

public class IteratorUtility {
    private static final long INVALID_ELEMENT = -1L;

    public static PrimitiveIterator.OfLong mergePrimitiveLongIterator(final PrimitiveIterator.OfLong iter1, final PrimitiveIterator.OfLong iter2) {
        return new PrimitiveIterator.OfLong(){
            private long curIter1Element = -1L;
            private long curIter2Element = -1L;
            private boolean hasToPreFetch = true;

            @Override
            public boolean hasNext() {
                if (this.hasToPreFetch) {
                    if (this.curIter1Element == -1L) {
                        long l = this.curIter1Element = iter1.hasNext() ? iter1.nextLong() : -1L;
                    }
                    if (this.curIter2Element == -1L) {
                        this.curIter2Element = iter2.hasNext() ? iter2.nextLong() : -1L;
                    }
                }
                this.hasToPreFetch = false;
                return this.curIter1Element != -1L || this.curIter2Element != -1L;
            }

            @Override
            public long nextLong() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                long returnEntryId = -1L;
                if (this.curIter1Element != -1L && this.curIter2Element != -1L) {
                    if (this.curIter1Element == this.curIter2Element) {
                        returnEntryId = this.curIter1Element;
                        this.curIter1Element = -1L;
                        this.curIter2Element = -1L;
                    } else if (this.curIter1Element < this.curIter2Element) {
                        returnEntryId = this.curIter1Element;
                        this.curIter1Element = -1L;
                    } else {
                        returnEntryId = this.curIter2Element;
                        this.curIter2Element = -1L;
                    }
                } else if (this.curIter1Element != -1L) {
                    returnEntryId = this.curIter1Element;
                    this.curIter1Element = -1L;
                } else {
                    returnEntryId = this.curIter2Element;
                    this.curIter2Element = -1L;
                }
                this.hasToPreFetch = true;
                return returnEntryId;
            }
        };
    }

    public static <T> PrimitiveIterator.OfLong mergeIteratorsForPrimitiveLongIterator(final Iterator<T> iter1, final Iterator<T> iter2, final Comparator<T> comparator, final ToLongFunction<T> function) {
        return new PrimitiveIterator.OfLong(){
            private T curIter1Entry = null;
            private T curIter2Entry = null;
            private boolean hasToPreFetch = true;

            @Override
            public boolean hasNext() {
                if (this.hasToPreFetch) {
                    if (this.curIter1Entry == null) {
                        this.curIter1Entry = iter1.hasNext() ? iter1.next() : null;
                        Object v0 = this.curIter1Entry;
                    }
                    if (this.curIter2Entry == null) {
                        this.curIter2Entry = iter2.hasNext() ? iter2.next() : null;
                    }
                }
                this.hasToPreFetch = false;
                return this.curIter1Entry != null || this.curIter2Entry != null;
            }

            @Override
            public long nextLong() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object returnEntry = null;
                if (this.curIter1Entry != null && this.curIter2Entry != null) {
                    int compareValue = comparator.compare(this.curIter1Entry, this.curIter2Entry);
                    if (compareValue == 0) {
                        returnEntry = this.curIter1Entry;
                        this.curIter1Entry = null;
                        this.curIter2Entry = null;
                    } else if (compareValue < 0) {
                        returnEntry = this.curIter1Entry;
                        this.curIter1Entry = null;
                    } else {
                        returnEntry = this.curIter2Entry;
                        this.curIter2Entry = null;
                    }
                } else if (this.curIter1Entry != null) {
                    returnEntry = this.curIter1Entry;
                    this.curIter1Entry = null;
                } else {
                    returnEntry = this.curIter2Entry;
                    this.curIter2Entry = null;
                }
                this.hasToPreFetch = true;
                return function.applyAsLong(returnEntry);
            }
        };
    }
}

