/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.bookkeeper.util;

import dlshade.org.apache.commons.lang3.tuple.Pair;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LedgerDirUtil {
    public static final Pattern FILE_PATTERN = Pattern.compile("^([0-9a-fA-F]+)\\.log$");
    public static final Pattern COMPACTED_FILE_PATTERN = Pattern.compile("^([0-9a-fA-F]+)\\.log\\.([0-9a-fA-F]+)\\.compacted$");

    public static List<Integer> logIdsInDirectory(File directory) {
        File[] files;
        ArrayList<Integer> ids = new ArrayList<Integer>();
        if (directory.exists() && directory.isDirectory() && (files = directory.listFiles()) != null && files.length > 0) {
            for (File f : files) {
                Matcher m = FILE_PATTERN.matcher(f.getName());
                if (!m.matches()) continue;
                int logId = Integer.parseUnsignedInt(m.group(1), 16);
                ids.add(logId);
            }
        }
        return ids;
    }

    public static List<Integer> compactedLogIdsInDirectory(File directory) {
        File[] files;
        ArrayList<Integer> ids = new ArrayList<Integer>();
        if (directory.exists() && directory.isDirectory() && (files = directory.listFiles()) != null && files.length > 0) {
            for (File f : files) {
                Matcher m = COMPACTED_FILE_PATTERN.matcher(f.getName());
                if (!m.matches()) continue;
                int logId = Integer.parseUnsignedInt(m.group(1), 16);
                ids.add(logId);
            }
        }
        return ids;
    }

    public static Pair<Integer, Integer> findLargestGap(List<Integer> currentIds) {
        if (currentIds.isEmpty()) {
            return Pair.of(0, Integer.MAX_VALUE);
        }
        Collections.sort(currentIds);
        int nextIdCandidate = 0;
        int maxIdCandidate = currentIds.get(0);
        int maxGap = maxIdCandidate - nextIdCandidate;
        for (int i = 0; i < currentIds.size(); ++i) {
            int gapSize;
            int gapStart = currentIds.get(i) + 1;
            int j = i + 1;
            int gapEnd = Integer.MAX_VALUE;
            if (j < currentIds.size()) {
                gapEnd = currentIds.get(j);
            }
            if ((gapSize = gapEnd - gapStart) <= maxGap) continue;
            maxGap = gapSize;
            nextIdCandidate = gapStart;
            maxIdCandidate = gapEnd;
        }
        return Pair.of(nextIdCandidate, maxIdCandidate);
    }
}

