/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.bookkeeper.zookeeper;

import dlshade.org.apache.bookkeeper.stats.Counter;
import dlshade.org.apache.bookkeeper.stats.NullStatsLogger;
import dlshade.org.apache.bookkeeper.stats.StatsLogger;
import dlshade.org.apache.zookeeper.KeeperException;
import dlshade.org.apache.zookeeper.WatchedEvent;
import dlshade.org.apache.zookeeper.Watcher;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperWatcherBase
implements Watcher {
    private static final Logger LOG = LoggerFactory.getLogger(ZooKeeperWatcherBase.class);
    private final int zkSessionTimeOut;
    private volatile CountDownLatch clientConnectLatch = new CountDownLatch(1);
    private final CopyOnWriteArraySet<Watcher> childWatchers = new CopyOnWriteArraySet();
    private final StatsLogger statsLogger;
    private final ConcurrentHashMap<Watcher.Event.KeeperState, Counter> stateCounters = new ConcurrentHashMap();
    private final ConcurrentHashMap<Watcher.Event.EventType, Counter> eventCounters = new ConcurrentHashMap();

    public ZooKeeperWatcherBase(int zkSessionTimeOut) {
        this(zkSessionTimeOut, NullStatsLogger.INSTANCE);
    }

    public ZooKeeperWatcherBase(int zkSessionTimeOut, StatsLogger statsLogger) {
        this(zkSessionTimeOut, new HashSet<Watcher>(), statsLogger);
    }

    public ZooKeeperWatcherBase(int zkSessionTimeOut, Set<Watcher> childWatchers, StatsLogger statsLogger) {
        this.zkSessionTimeOut = zkSessionTimeOut;
        this.childWatchers.addAll(childWatchers);
        this.statsLogger = statsLogger;
    }

    public ZooKeeperWatcherBase addChildWatcher(Watcher watcher) {
        this.childWatchers.add(watcher);
        return this;
    }

    public ZooKeeperWatcherBase removeChildWatcher(Watcher watcher) {
        this.childWatchers.remove(watcher);
        return this;
    }

    private Counter getEventCounter(Watcher.Event.EventType type) {
        Counter c = this.eventCounters.get((Object)type);
        if (null == c) {
            Counter newCounter = this.statsLogger.scope("events").getCounter(type.name());
            Counter oldCounter = this.eventCounters.putIfAbsent(type, newCounter);
            c = null != oldCounter ? oldCounter : newCounter;
        }
        return c;
    }

    public Counter getStateCounter(Watcher.Event.KeeperState state) {
        Counter c = this.stateCounters.get((Object)state);
        if (null == c) {
            Counter newCounter = this.statsLogger.scope("state").getCounter(state.name());
            Counter oldCounter = this.stateCounters.putIfAbsent(state, newCounter);
            c = null != oldCounter ? oldCounter : newCounter;
        }
        return c;
    }

    @Override
    public void process(WatchedEvent event) {
        if (event.getType() != Watcher.Event.EventType.None) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Received event: {}, path: {} from ZooKeeper server", (Object)event.getType(), (Object)event.getPath());
            }
            this.getEventCounter(event.getType()).inc();
            this.notifyEvent(event);
            return;
        }
        this.getStateCounter(event.getState()).inc();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Received {} from ZooKeeper server", (Object)event.getState());
        }
        switch (event.getState()) {
            case SyncConnected: {
                LOG.info("ZooKeeper client is connected now.");
                this.clientConnectLatch.countDown();
                break;
            }
            case Disconnected: {
                LOG.info("ZooKeeper client is disconnected from zookeeper now, but it is OK unless we received EXPIRED event.");
                break;
            }
            case Expired: {
                this.clientConnectLatch = new CountDownLatch(1);
                LOG.error("ZooKeeper client connection to the ZooKeeper server has expired!");
                break;
            }
        }
        this.notifyEvent(event);
    }

    public void waitForConnection() throws KeeperException, InterruptedException {
        if (!this.clientConnectLatch.await(this.zkSessionTimeOut, TimeUnit.MILLISECONDS)) {
            throw KeeperException.create(KeeperException.Code.CONNECTIONLOSS);
        }
    }

    public int getZkSessionTimeOut() {
        return this.zkSessionTimeOut;
    }

    private void notifyEvent(WatchedEvent event) {
        for (Watcher w : this.childWatchers) {
            try {
                w.process(event);
            }
            catch (Exception t) {
                LOG.warn("Encountered unexpected exception from watcher {} : ", (Object)w, (Object)t);
            }
        }
    }
}

