/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.distributedlog;

import dlshade.org.apache.bookkeeper.client.AsyncCallback;
import dlshade.org.apache.bookkeeper.client.BKException;
import dlshade.org.apache.bookkeeper.client.BookKeeper;
import dlshade.org.apache.bookkeeper.client.LedgerHandle;
import dlshade.org.apache.bookkeeper.client.RegionAwareEnsemblePlacementPolicy;
import dlshade.org.apache.bookkeeper.common.concurrent.FutureUtils;
import dlshade.org.apache.bookkeeper.conf.ClientConfiguration;
import dlshade.org.apache.bookkeeper.feature.FeatureProvider;
import dlshade.org.apache.bookkeeper.net.DNSToSwitchMapping;
import dlshade.org.apache.bookkeeper.stats.StatsLogger;
import dlshade.org.apache.bookkeeper.zookeeper.BoundExponentialBackoffRetryPolicy;
import dlshade.org.apache.distributedlog.DistributedLogConfiguration;
import dlshade.org.apache.distributedlog.ZooKeeperClient;
import dlshade.org.apache.distributedlog.bk.LedgerMetadata;
import dlshade.org.apache.distributedlog.exceptions.AlreadyClosedException;
import dlshade.org.apache.distributedlog.exceptions.DLInterruptedException;
import dlshade.org.apache.distributedlog.net.NetUtils;
import dlshade.org.apache.distributedlog.util.ConfUtils;
import io.netty.channel.EventLoopGroup;
import io.netty.util.HashedWheelTimer;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BookKeeperClient {
    static final Logger LOG = LoggerFactory.getLogger(BookKeeperClient.class);
    private final DistributedLogConfiguration conf;
    private final String name;
    private final String zkServers;
    private final String ledgersPath;
    private final byte[] passwd;
    private final EventLoopGroup eventLoopGroup;
    private final HashedWheelTimer requestTimer;
    private final StatsLogger statsLogger;
    private boolean closed = false;
    private BookKeeper bkc = null;
    private ZooKeeperClient zkc;
    private final boolean ownZK;
    private final Optional<FeatureProvider> featureProvider;

    private synchronized void commonInitialization(DistributedLogConfiguration conf, String ledgersPath, EventLoopGroup eventLoopGroup, StatsLogger statsLogger, HashedWheelTimer requestTimer) throws IOException, InterruptedException {
        Class<? extends DNSToSwitchMapping> dnsResolverCls;
        ClientConfiguration bkConfig = new ClientConfiguration();
        bkConfig.setAddEntryTimeout(conf.getBKClientWriteTimeout());
        bkConfig.setReadTimeout(conf.getBKClientReadTimeout());
        bkConfig.setZkLedgersRootPath(ledgersPath);
        bkConfig.setZkTimeout(conf.getBKClientZKSessionTimeoutMilliSeconds());
        bkConfig.setNumWorkerThreads(conf.getBKClientNumberWorkerThreads());
        bkConfig.setEnsemblePlacementPolicy(RegionAwareEnsemblePlacementPolicy.class);
        bkConfig.setZkRequestRateLimit(conf.getBKClientZKRequestRateLimit());
        bkConfig.setProperty("reppDisallowBookiePlacementInRegionFeatureName", "disallow_bookie_placement");
        ConfUtils.loadConfiguration((Configuration)bkConfig, (Configuration)conf, "bkc.");
        try {
            dnsResolverCls = conf.getEnsemblePlacementDnsResolverClass();
        }
        catch (ConfigurationException e) {
            LOG.error("Failed to load bk dns resolver : ", (Throwable)e);
            throw new IOException("Failed to load bk dns resolver : ", e);
        }
        DNSToSwitchMapping dnsResolver = NetUtils.getDNSResolver(dnsResolverCls, conf.getBkDNSResolverOverrides());
        try {
            this.bkc = BookKeeper.forConfig(bkConfig).setZookeeper(this.zkc.get()).setEventLoopGroup(eventLoopGroup).setStatsLogger(statsLogger).dnsResolver(dnsResolver).requestTimer(requestTimer).featureProvider(this.featureProvider.orElse(null)).build();
        }
        catch (BKException bke) {
            throw new IOException(bke);
        }
    }

    BookKeeperClient(DistributedLogConfiguration conf, String name, String zkServers, ZooKeeperClient zkc, String ledgersPath, EventLoopGroup eventLoopGroup, HashedWheelTimer requestTimer, StatsLogger statsLogger, Optional<FeatureProvider> featureProvider) {
        this.conf = conf;
        this.name = name;
        this.zkServers = zkServers;
        this.ledgersPath = ledgersPath;
        this.passwd = conf.getBKDigestPW().getBytes(StandardCharsets.UTF_8);
        this.eventLoopGroup = eventLoopGroup;
        this.requestTimer = requestTimer;
        this.statsLogger = statsLogger;
        this.featureProvider = featureProvider;
        boolean bl = this.ownZK = null == zkc;
        if (null != zkc) {
            this.zkc = zkc;
        }
    }

    private synchronized void initialize() throws IOException {
        if (null != this.bkc) {
            return;
        }
        if (null == this.zkc) {
            int zkSessionTimeout = this.conf.getBKClientZKSessionTimeoutMilliSeconds();
            BoundExponentialBackoffRetryPolicy retryPolicy = new BoundExponentialBackoffRetryPolicy(this.conf.getBKClientZKRetryBackoffStartMillis(), this.conf.getBKClientZKRetryBackoffMaxMillis(), this.conf.getBKClientZKNumRetries());
            ZooKeeperClient.Credentials credentials = ZooKeeperClient.Credentials.NONE;
            if (this.conf.getZkAclId() != null) {
                credentials = new ZooKeeperClient.DigestCredentials(this.conf.getZkAclId(), this.conf.getZkAclId());
            }
            this.zkc = new ZooKeeperClient(this.name + ":zk", zkSessionTimeout, 2 * zkSessionTimeout, this.zkServers, retryPolicy, this.statsLogger.scope("bkc_zkc"), this.conf.getZKClientNumberRetryThreads(), this.conf.getBKClientZKRequestRateLimit(), credentials);
        }
        try {
            this.commonInitialization(this.conf, this.ledgersPath, this.eventLoopGroup, this.statsLogger, this.requestTimer);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new DLInterruptedException("Interrupted on creating bookkeeper client " + this.name + " : ", (Throwable)e);
        }
        if (this.ownZK) {
            LOG.info("BookKeeper Client created {} with its own ZK Client : ledgersPath = {}, numRetries = {}, sessionTimeout = {}, backoff = {}, maxBackoff = {}, dnsResolver = {}", new Object[]{this.name, this.ledgersPath, this.conf.getBKClientZKNumRetries(), this.conf.getBKClientZKSessionTimeoutMilliSeconds(), this.conf.getBKClientZKRetryBackoffStartMillis(), this.conf.getBKClientZKRetryBackoffMaxMillis(), this.conf.getBkDNSResolverOverrides()});
        } else {
            LOG.info("BookKeeper Client created {} with shared zookeeper client : ledgersPath = {}, numRetries = {}, sessionTimeout = {}, backoff = {}, maxBackoff = {}, dnsResolver = {}", new Object[]{this.name, this.ledgersPath, this.conf.getZKNumRetries(), this.conf.getZKSessionTimeoutMilliseconds(), this.conf.getZKRetryBackoffStartMillis(), this.conf.getZKRetryBackoffMaxMillis(), this.conf.getBkDNSResolverOverrides()});
        }
    }

    public synchronized BookKeeper get() throws IOException {
        this.checkClosedOrInError();
        if (null == this.bkc) {
            this.initialize();
        }
        return this.bkc;
    }

    public CompletableFuture<LedgerHandle> createLedger(int ensembleSize, int writeQuorumSize, int ackQuorumSize, LedgerMetadata ledgerMetadata) {
        BookKeeper bk;
        try {
            bk = this.get();
        }
        catch (IOException ioe) {
            return FutureUtils.exception(ioe);
        }
        final CompletableFuture<LedgerHandle> promise = new CompletableFuture<LedgerHandle>();
        bk.asyncCreateLedger(ensembleSize, writeQuorumSize, ackQuorumSize, BookKeeper.DigestType.CRC32, this.passwd, new AsyncCallback.CreateCallback(){

            @Override
            public void createComplete(int rc, LedgerHandle lh, Object ctx) {
                if (0 == rc) {
                    promise.complete(lh);
                } else {
                    promise.completeExceptionally(BKException.create(rc));
                }
            }
        }, null, ledgerMetadata == null ? Collections.emptyMap() : ledgerMetadata.getMetadata());
        return promise;
    }

    public CompletableFuture<Void> deleteLedger(long lid, final boolean ignoreNonExistentLedger) {
        BookKeeper bk;
        try {
            bk = this.get();
        }
        catch (IOException ioe) {
            return FutureUtils.exception(ioe);
        }
        final CompletableFuture<Void> promise = new CompletableFuture<Void>();
        bk.asyncDeleteLedger(lid, new AsyncCallback.DeleteCallback(){

            @Override
            public void deleteComplete(int rc, Object ctx) {
                if (0 == rc) {
                    promise.complete(null);
                } else if (-25 == rc) {
                    if (ignoreNonExistentLedger) {
                        promise.complete(null);
                    } else {
                        promise.completeExceptionally(BKException.create(rc));
                    }
                } else {
                    promise.completeExceptionally(BKException.create(rc));
                }
            }
        }, null);
        return promise;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        ZooKeeperClient zkcToClose;
        BookKeeper bkcToClose;
        BookKeeperClient bookKeeperClient = this;
        synchronized (bookKeeperClient) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            bkcToClose = this.bkc;
            zkcToClose = this.zkc;
        }
        LOG.info("BookKeeper Client closed {}", (Object)this.name);
        if (null != bkcToClose) {
            try {
                bkcToClose.close();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LOG.warn("Interrupted on closing bookkeeper client {} : ", (Object)this.name, (Object)e);
                Thread.currentThread().interrupt();
            }
            catch (BKException e) {
                LOG.warn("Error on closing bookkeeper client {} : ", (Object)this.name, (Object)e);
            }
        }
        if (null != zkcToClose && this.ownZK) {
            zkcToClose.close();
        }
    }

    public synchronized void checkClosedOrInError() throws AlreadyClosedException {
        if (this.closed) {
            LOG.error("BookKeeper Client {} is already closed", (Object)this.name);
            throw new AlreadyClosedException("BookKeeper Client " + this.name + " is already closed");
        }
    }
}

